/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuVisitor;
import javax.ide.menu.spi.Positionable;
import javax.ide.menu.spi.PositionableVisitor;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.SectionContainer;

final class SectionVisitor
extends PositionableVisitor {
    static final ElementName SECTION = new ElementName("http://jcp.org/jsr/198/extension-manifest", "section");
    private static final ElementName ITEM = new ElementName("http://jcp.org/jsr/198/extension-manifest", "item");
    private ElementVisitor _menuVisitor = new MenuInSectionVisitor();
    private ElementVisitor _itemVisitor = new ItemVisitor();
    private static final String KEY_SECTION = "section";
    private static final String ALPHASORT = "alphasort";
    private static final String RESOLVE_MNEMONICS = "resolveMnemonics";
    private static final String DISPLAY_LABEL = "displayName";

    SectionVisitor() {
    }

    @Override
    protected void positionable(ElementStartContext context, String id, String before, String after, Float weight) {
        String displayName;
        String resolveMnemonics;
        String alphaSort;
        SectionContainer container = (SectionContainer)context.getScopeData().get("sectionContainer");
        Section section = container.getSection(id);
        if (section == null) {
            section = new Section(id);
            container.addSection(section);
        }
        if ((alphaSort = context.getAttributeValue(ALPHASORT)) != null) {
            section.setSortSectionAlphabetically(Boolean.valueOf(alphaSort));
        }
        if ((resolveMnemonics = context.getAttributeValue(RESOLVE_MNEMONICS)) != null) {
            section.setResolveMnemonics(Boolean.valueOf(resolveMnemonics));
        }
        if ((displayName = context.getAttributeValue(DISPLAY_LABEL)) != null && (displayName = displayName.trim()).length() > 0) {
            if (section.getDisplayName() != null) {
                this.log(context, Level.WARNING, "The display name has already been set for section " + id);
            } else {
                section.setDisplayName(displayName);
            }
        }
        if (weight != null) {
            Float w = section.getWeight();
            if (w == null) {
                section.setWeight(weight);
            } else if (!w.equals(weight)) {
                this.log(context, Level.INFO, "Section " + id + " already has an assigned weight of " + w + ". The section weight will not be redefined to " + weight + ".");
            }
        } else if (before != null) {
            section.setBefore(before);
        } else if (after != null) {
            section.setAfter(after);
        }
        context.getScopeData().put(KEY_SECTION, section);
        context.registerChildVisitor(MenuVisitor.MENU, this._menuVisitor);
        context.registerChildVisitor(ITEM, this._itemVisitor);
    }

    private Section getSection(ElementContext context) {
        return (Section)context.getScopeData().get(KEY_SECTION);
    }

    private final class MenuInSectionVisitor
    extends MenuVisitor {
        private MenuInSectionVisitor() {
        }

        @Override
        protected void positionable(ElementStartContext context, String id, String before, String after, Float weight) {
            Section parentSection = SectionVisitor.this.getSection(context);
            Positionable pos = parentSection.getItem(id);
            if (pos == null) {
                pos = new Menu(id);
                parentSection.addItem(pos);
            } else if (pos instanceof Item) {
                this.log(context, Level.SEVERE, "'" + id + "' is already defined as an item in section '" + parentSection.getID() + "'");
                return;
            }
            Menu menu = (Menu)pos;
            this.processMenu(context, menu, before, after, weight);
        }
    }

    private final class ItemVisitor
    extends PositionableVisitor {
        ItemVisitor() {
            super("action-ref");
        }

        @Override
        protected void positionable(ElementStartContext context, String id, String before, String after, Float weight) {
            Section parentSection = SectionVisitor.this.getSection(context);
            Positionable pos = parentSection.getItem(id);
            if (pos == null) {
                pos = new Item(id);
                parentSection.addItem(pos);
            } else if (pos instanceof Menu) {
                this.log(context, Level.SEVERE, "'" + id + "' is already defined as a menu in section '" + parentSection.getID() + "'");
                return;
            }
            Item item = (Item)pos;
            String radioGroupId = context.getAttributeValue("radiogroup-id");
            if (radioGroupId != null) {
                radioGroupId = radioGroupId.trim();
                item.setRadioGroupID(radioGroupId);
            }
            if (weight != null) {
                item.setWeight(weight);
            } else if (before != null) {
                item.setBefore(before);
            } else if (after != null) {
                item.setAfter(after);
            }
        }
    }
}

