/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.command.Controller;
import javax.ide.extension.BooleanVisitor;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.I18NCharVisitor;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.IconVisitor;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.menu.IDEAction;
import javax.ide.menu.spi.MenuModel;
import javax.ide.util.IconDescription;
import javax.ide.util.MetaClass;

final class ActionsVisitor
extends ElementVisitor {
    static final String KEY_ACTION = "action";
    private static final ElementName ACTION = new ElementName("http://jcp.org/jsr/198/extension-manifest", "action");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName MNEMONIC = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mnemonic");
    private static final ElementName TOOLTIP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "tooltip");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private static final ElementName ENABLED = new ElementName("http://jcp.org/jsr/198/extension-manifest", "enabled");
    private static final ElementName CHECKED = new ElementName("http://jcp.org/jsr/198/extension-manifest", "checked");
    private static final ElementName INVOKE_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "invoke-class");
    private static final ElementName UPDATE_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "update-class");
    private static final ElementName ACTION_OVERRIDE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "action-override");
    private ElementVisitor _actionHandler = new ActionVisitor();
    private ElementVisitor _labelHandler = new LabelHandler();
    private ElementVisitor _mnemonicHandler = new MnemonicHandler();
    private ElementVisitor _tooltipHandler = new TooltipHandler();
    private ElementVisitor _iconpathHandler = new IconpathHandler();
    private ElementVisitor _enabledHandler = new EnabledHandler();
    private ElementVisitor _checkedHandler = new CheckedHandler();
    private ElementVisitor _invokeClassVisitor = new InvokeClassVisitor();
    private ElementVisitor _updateClassVisitor = new UpdateClassVisitor();
    private ElementVisitor _actionOverrideVisitor = new ActionOverrideVisitor();
    private static final String KEY_CONTROLLER_HOLDER = "controllerHolder";
    private static final String KEY_ACTION_REF = "actionRef";

    ActionsVisitor() {
    }

    @Override
    public void start(ElementStartContext context) {
        context.registerChildVisitor(ACTION, this._actionHandler);
        context.registerChildVisitor(ACTION_OVERRIDE, this._actionOverrideVisitor);
    }

    private IDEAction getAction(ElementContext context) {
        return (IDEAction)context.getScopeData().get(KEY_ACTION);
    }

    private final class ControllerHolder {
        private MetaClass invokeClass;
        private MetaClass updateClass;

        private ControllerHolder() {
        }
    }

    private class InvokeClassVisitor
    extends MetaClassVisitor {
        private InvokeClassVisitor() {
        }

        @Override
        public void metaClass(ElementContext context, MetaClass mc) {
            ControllerHolder ch = (ControllerHolder)context.getScopeData().get(ActionsVisitor.KEY_CONTROLLER_HOLDER);
            ch.invokeClass = mc;
        }
    }

    private class UpdateClassVisitor
    extends MetaClassVisitor {
        private UpdateClassVisitor() {
        }

        @Override
        public void metaClass(ElementContext context, MetaClass mc) {
            ControllerHolder ch = (ControllerHolder)context.getScopeData().get(ActionsVisitor.KEY_CONTROLLER_HOLDER);
            ch.updateClass = mc;
        }
    }

    private class CheckedHandler
    extends BooleanVisitor {
        private CheckedHandler() {
        }

        @Override
        public void booleanValue(ElementContext context, boolean value) {
            ActionsVisitor.this.getAction(context).setChecked(value);
        }
    }

    private class EnabledHandler
    extends BooleanVisitor {
        private EnabledHandler() {
        }

        @Override
        public void booleanValue(ElementContext context, boolean value) {
            ActionsVisitor.this.getAction(context).setEnabled(value);
        }
    }

    private class IconpathHandler
    extends IconVisitor {
        private IconpathHandler() {
        }

        @Override
        public void icon(ElementContext context, IconDescription icon) {
            ActionsVisitor.this.getAction(context).setIcon(icon);
        }
    }

    private class TooltipHandler
    extends I18NStringVisitor {
        private TooltipHandler() {
        }

        @Override
        public void string(ElementContext context, String text) {
            ActionsVisitor.this.getAction(context).setToolTip(text);
        }
    }

    private class MnemonicHandler
    extends I18NCharVisitor {
        private MnemonicHandler() {
        }

        @Override
        public void characterValue(ElementContext context, char theChar) {
            ActionsVisitor.this.getAction(context).setMnemonic(theChar);
        }
    }

    private class LabelHandler
    extends I18NStringVisitor {
        private LabelHandler() {
        }

        @Override
        public void string(ElementContext context, String text) {
            ActionsVisitor.this.getAction(context).setLabel(text);
        }
    }

    private class ActionOverrideVisitor
    extends ElementVisitor {
        private ActionOverrideVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String actionRef = context.getAttributeValue("action-ref");
            if (actionRef == null || (actionRef = actionRef.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'action-ref'.");
                return;
            }
            context.getScopeData().put(ActionsVisitor.KEY_ACTION_REF, actionRef);
            context.getScopeData().put(ActionsVisitor.KEY_CONTROLLER_HOLDER, new ControllerHolder());
            context.registerChildVisitor(UPDATE_CLASS, ActionsVisitor.this._updateClassVisitor);
            context.registerChildVisitor(INVOKE_CLASS, ActionsVisitor.this._invokeClassVisitor);
        }

        @Override
        public void end(ElementEndContext context) {
            ControllerHolder holder = (ControllerHolder)context.getScopeData().get(ActionsVisitor.KEY_CONTROLLER_HOLDER);
            if (holder.invokeClass == null) {
                this.log(context, Level.SEVERE, "Missing required element 'invoke-class'.");
                return;
            }
            String actionRef = (String)context.getScopeData().get(ActionsVisitor.KEY_ACTION_REF);
            MenuModel model = (MenuModel)context.getScopeData().get("menuModel");
            model.addController(actionRef, new Controller(holder.invokeClass, holder.updateClass));
        }
    }

    private class ActionVisitor
    extends ElementVisitor {
        private ActionVisitor() {
        }

        @Override
        public void start(ElementStartContext start) {
            String id = start.getAttributeValue("id").trim();
            if (id == null) {
                this.log(start, Level.SEVERE, "Missing attribute 'id'");
            } else {
                MenuModel model = (MenuModel)start.getScopeData().get("menuModel");
                if (!model.isUniqueActionId(id)) {
                    this.log(start, Level.SEVERE, "Duplicate definition of action id '" + id + "'");
                    return;
                }
                String toggleText = start.getAttributeValue("toggle");
                boolean isToggle = toggleText == null ? false : Boolean.valueOf(toggleText.trim());
                IDEAction action = new IDEAction(id);
                action.setToggleItem(isToggle);
                start.getScopeData().put(ActionsVisitor.KEY_ACTION, action);
                start.getScopeData().put(ActionsVisitor.KEY_CONTROLLER_HOLDER, new ControllerHolder());
                start.registerChildVisitor(LABEL, ActionsVisitor.this._labelHandler);
                start.registerChildVisitor(MNEMONIC, ActionsVisitor.this._mnemonicHandler);
                start.registerChildVisitor(TOOLTIP, ActionsVisitor.this._tooltipHandler);
                start.registerChildVisitor(ICONPATH, ActionsVisitor.this._iconpathHandler);
                start.registerChildVisitor(ENABLED, ActionsVisitor.this._enabledHandler);
                start.registerChildVisitor(CHECKED, ActionsVisitor.this._checkedHandler);
                start.registerChildVisitor(UPDATE_CLASS, ActionsVisitor.this._updateClassVisitor);
                start.registerChildVisitor(INVOKE_CLASS, ActionsVisitor.this._invokeClassVisitor);
            }
        }

        @Override
        public void end(ElementEndContext context) {
            IDEAction action = ActionsVisitor.this.getAction(context);
            ControllerHolder holder = (ControllerHolder)context.getScopeData().get(ActionsVisitor.KEY_CONTROLLER_HOLDER);
            if (action.getLabel() == null) {
                this.log(context, Level.SEVERE, "Required element 'label' missing.");
                return;
            }
            MenuModel model = (MenuModel)context.getScopeData().get("menuModel");
            if (holder.invokeClass != null) {
                Controller controller = new Controller(holder.invokeClass, holder.updateClass);
                model.addController(action.getID(), controller);
            }
            model.addAction(ActionsVisitor.this.getAction(context));
        }
    }
}

