/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.util.ArrayList;
import java.util.List;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.OnDemandElementVisitorListener;

public class OnDemandElementVisitor
extends ElementVisitor {
    private ArrayList<OnDemandElementVisitorListener> _regListeners;

    @Override
    public final void start(ElementStartContext context) {
        String extId = context.getExtension().getID();
        this.notifyRegListeners(extId, true);
        super.start(context);
        this.startImpl(context);
    }

    @Override
    public final void end(ElementEndContext context) {
        super.end(context);
        this.endImpl(context);
        String extId = context.getExtension().getID();
        this.notifyRegListeners(extId, false);
    }

    protected void startImpl(ElementStartContext context) {
    }

    protected void endImpl(ElementEndContext context) {
    }

    public final synchronized void addRegListener(OnDemandElementVisitorListener listener) {
        if (listener != null) {
            if (this._regListeners == null) {
                this._regListeners = new ArrayList(5);
            }
            this._regListeners.add(listener);
        }
    }

    public final synchronized void removeRegListener(OnDemandElementVisitorListener listener) {
        if (this._regListeners != null && listener != null) {
            this._regListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRegListeners(String extensionId, boolean isStarting) {
        List list;
        OnDemandElementVisitor onDemandElementVisitor = this;
        synchronized (onDemandElementVisitor) {
            if (this._regListeners == null) {
                return;
            }
            list = (List)this._regListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            OnDemandElementVisitorListener listener = (OnDemandElementVisitorListener)list.get(i);
            if (isStarting) {
                listener.starting(extensionId);
                continue;
            }
            listener.ended(extensionId);
        }
    }
}

