/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ExtensionHook;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class DOMHook
extends ExtensionHook {
    private static final String KEY_PARENT_ELEMENT = "parentElement";
    private final ElementVisitor _genericVisitor = new GenericVisitor();
    private final ElementVisitorFactory _genericVisitorFactory = new ElementVisitorFactory(){

        @Override
        public ElementVisitor getVisitor(ElementName name) {
            return DOMHook.this._genericVisitor;
        }
    };
    private final DocumentBuilder _documentBuilder;
    private final Document _document;

    public DOMHook() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this._documentBuilder = dbf.newDocumentBuilder();
            this._document = this._documentBuilder.newDocument();
            Element rootElement = DOMHook.createElement(this._document, this.getRootElementName());
            this._document.appendChild(rootElement);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Parser configuration error", e);
        }
    }

    public Element getRootElement() {
        return this._document.getDocumentElement();
    }

    @Override
    public void start(ElementStartContext context) {
        context.registerVisitorFactory(this._genericVisitorFactory);
        context.getScopeData().put(KEY_PARENT_ELEMENT, this._document.getDocumentElement());
    }

    @Override
    public void end(ElementEndContext context) {
    }

    private static Element getParentElement(ElementContext context) {
        return (Element)context.getScopeData().get(KEY_PARENT_ELEMENT);
    }

    private static Element createElement(Document doc, ElementName elementName) {
        return doc.createElementNS(elementName.getNamespaceURI(), elementName.getLocalName());
    }

    protected abstract ElementName getRootElementName();

    private final class GenericVisitor
    extends ElementVisitor {
        private GenericVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            Element newElement = DOMHook.createElement(DOMHook.this._document, context.getElementName());
            for (String attributeName : context.getAttributeNames()) {
                String attributeValue = context.getAttributeValue(attributeName);
                newElement.setAttribute(attributeName, attributeValue);
            }
            Element parentElement = DOMHook.getParentElement(context);
            parentElement.appendChild(newElement);
            context.getScopeData().put(DOMHook.KEY_PARENT_ELEMENT, newElement);
        }

        @Override
        public void end(ElementEndContext context) {
            String text = context.getText();
            if (text != null) {
                Text textNode = DOMHook.this._document.createTextNode(text);
                DOMHook.getParentElement(context).appendChild(textNode);
            }
        }
    }
}

