/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.config.Preferences;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.ApplicationTemplate;
import oracle.jdeveloper.template.DefaultTemplateData;
import oracle.jdeveloper.template.ProjectTemplate;
import oracle.jdeveloper.template.TemplateArb;
import oracle.jdeveloper.template.TemplateCustomizationHook;
import oracle.jdeveloper.template.TemplateHook;
import oracle.jdeveloper.template.TemplateManager;
import oracle.jdeveloper.template.TemplatePreferences;
import oracle.jdeveloper.wizard.apptemplate.ApplicationTemplateHookHandler;

final class TemplateRegistrar {
    private TemplateHookListener _listener;
    private String _defaultTemplateId;
    private boolean _updatedDefaultTemplate;
    private static final TemplateRegistrar _instance = new TemplateRegistrar();

    TemplateRegistrar() {
    }

    public static TemplateRegistrar getInstance() {
        return _instance;
    }

    void registerAllTemplates(TemplateManager mgr) {
        this.initializeIfNeeded(mgr);
    }

    private synchronized void initializeIfNeeded(TemplateManager mgr) {
        if (this._listener == null) {
            this.registerUserAndSharedTemplates(mgr);
            TemplateCustomizationHook customizationHook = TemplateCustomizationHook.get();
            if (customizationHook.isDefaultTemplateDefined()) {
                this._defaultTemplateId = customizationHook.getDefaultTemplateId();
            } else {
                this._updatedDefaultTemplate = true;
            }
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            TemplateHook hook = (TemplateHook)registry.getHook(TemplateHook.ELEMENT_NAME);
            Assert.check((hook != null ? 1 : 0) != 0, (String)"Could not get TemplateHook from ExtensionRegistry");
            this._listener = new TemplateHookListener(mgr);
            hook.addHashStructureHookListener(this._listener);
            ApplicationTemplateHookHandler oldHook = (ApplicationTemplateHookHandler)registry.getHook(ApplicationTemplateHookHandler.ELEMENT);
            Assert.check((hook != null ? 1 : 0) != 0, (String)"Could not get ApplicationTemplateHookHandler from ExtensionRegistry");
            oldHook.registerTemplates(mgr);
        }
    }

    private void registerUserAndSharedTemplates(TemplateManager mgr) {
        TemplatePreferences prefs = TemplatePreferences.getInstance((PropertyStorage)Preferences.getPreferences());
        List<URL> urls = prefs.getTemplateDataURLs();
        for (URL url : urls) {
            try {
                DefaultTemplateData td = DefaultTemplateData.load(url);
                mgr.addTemplateData(td);
            }
            catch (IOException e) {
                mgr.getLogger().warning(TemplateArb.format(0, url.getPath()));
            }
        }
    }

    private class TemplateHookListener
    implements HashStructureHookListener {
        private final TemplateManager _manager;

        TemplateHookListener(TemplateManager mgr) {
            this._manager = mgr;
        }

        public void listenerAttached(HashStructureHookEvent e) {
            this.registerExtensionTemplates((TemplateHook)e.getHashStructureHook(), e.getCombinedHashStructure());
        }

        public void elementVisited(HashStructureHookEvent e) {
            this.registerExtensionTemplates((TemplateHook)e.getHashStructureHook(), e.getNewElementHashStructure());
        }

        private void registerExtensionTemplates(TemplateHook templateHook, HashStructure data) {
            List<ApplicationTemplate> appTemplates;
            templateHook.registerTemplates(this._manager, data, this._manager.getDefaultTemplateData());
            if (TemplateRegistrar.this._updatedDefaultTemplate) {
                return;
            }
            if (TemplateRegistrar.this._defaultTemplateId != null && this.maybeReconfigureDefaultTemplate(appTemplates = this._manager.getApplicationTemplates())) {
                TemplateRegistrar.this._updatedDefaultTemplate = true;
                List<AbstractTemplate> allTemplates = this._manager.getAllTemplates();
                for (AbstractTemplate t : allTemplates) {
                    t.setUnsorted(false);
                }
            }
            if (!TemplateRegistrar.this._updatedDefaultTemplate) {
                Logger.getLogger("oracle.jdeveloper.template.TemplateRegistrar").log(Level.WARNING, "No application template found with id " + TemplateRegistrar.this._defaultTemplateId);
                TemplateRegistrar.this._updatedDefaultTemplate = true;
            }
        }

        private boolean maybeReconfigureDefaultTemplate(List<ApplicationTemplate> appTemplates) {
            boolean updatedTemplate = false;
            for (ApplicationTemplate appTemplate : appTemplates) {
                if (!appTemplate.getTemplateId().equals(TemplateRegistrar.this._defaultTemplateId)) continue;
                appTemplate.setDefaultTemplate(true);
                List<ProjectTemplate> projTemplates = appTemplate.getProjectTemplates();
                ArrayList<String> templateIds = new ArrayList<String>(projTemplates.size());
                for (ProjectTemplate projTemplate : projTemplates) {
                    templateIds.add(projTemplate.getTemplateId());
                }
                this.updateDefaultProjectTemplates(templateIds);
                updatedTemplate = true;
                break;
            }
            return updatedTemplate;
        }

        private void updateDefaultProjectTemplates(List<String> projectTemplateIds) {
            List<ProjectTemplate> projectTemplates = this._manager.getProjectTemplates();
            for (ProjectTemplate t : projectTemplates) {
                if (!projectTemplateIds.contains(t.getTemplateId())) continue;
                t.setDefaultTemplate(true);
            }
        }
    }
}

