/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import javax.ide.extension.ElementName;
import oracle.ide.extension.HashStructureHook;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.AddonPageTemplate;
import oracle.jdeveloper.template.ApplicationTemplate;
import oracle.jdeveloper.template.ProjectTemplate;
import oracle.jdeveloper.template.TemplateData;
import oracle.jdeveloper.template.TemplateFactory;
import oracle.jdeveloper.template.TemplateManager;
import oracle.jdeveloper.template.TemplateUtils;

class TemplateHook
extends HashStructureHook {
    public static ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "template-hook");

    TemplateHook() {
    }

    void registerTemplates(TemplateManager mgr, HashStructure hookData, TemplateData lookup) {
        List addonPages;
        List projectTemplates = hookData.getAsList("projectTemplate");
        if (projectTemplates != null) {
            for (HashStructure hash : projectTemplates) {
                this.createAndRegisterTemplate(mgr, hash, ProjectTemplate.class, lookup);
            }
        }
        LinkedList<ApplicationTemplate> templateList = new LinkedList<ApplicationTemplate>();
        List applicationTemplates = hookData.getAsList("applicationTemplate");
        if (applicationTemplates != null) {
            for (HashStructure hash : applicationTemplates) {
                AbstractTemplate template = this.createAndRegisterTemplate(mgr, hash, ApplicationTemplate.class, lookup);
                if (!(template instanceof ApplicationTemplate)) continue;
                ApplicationTemplate appTemplate = (ApplicationTemplate)template;
                templateList.add(appTemplate);
            }
        }
        if ((addonPages = hookData.getAsList("applicationAddonPage")) != null) {
            for (HashStructure hash : addonPages) {
                AddonPageTemplate addonPage = new AddonPageTemplate(hash);
                for (ApplicationTemplate appTemplate : templateList) {
                    List<String> groups = appTemplate.getAddonPageGroups();
                    if (groups == null) continue;
                    for (String group : groups) {
                        if (group != addonPage.getAddonPageGroup()) continue;
                        appTemplate.addAddonPage(addonPage);
                    }
                }
            }
        }
    }

    private AbstractTemplate createAndRegisterTemplate(TemplateManager mgr, HashStructure hash, Class clazz, TemplateData lookup) {
        TemplateFactory tf = TemplateFactory.getInstance();
        AbstractTemplate template = null;
        try {
            template = tf.createTemplateFromExtensionHook(hash, clazz, lookup);
            mgr.registerTemplate(template);
        }
        catch (ClassNotFoundException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        catch (NoSuchMethodException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        catch (InstantiationException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        catch (IllegalAccessException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        catch (InvocationTargetException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        return template;
    }
}

