/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.TemplateData;
import oracle.jdeveloper.template.TemplateFactory;
import oracle.jdeveloper.template.TemplateUtils;

public class DefaultTemplateData
extends HashStructureAdapter
implements TemplateData {
    final HashMap<String, AbstractTemplate> templates_ = new HashMap();
    TemplateData parent_;
    URL url_;
    private static String KEY_URL = "url";
    private static String KEY_TEMPLATES = "templates";
    private static String TEMPLATE_DATA_ROOT = "template-data";

    public DefaultTemplateData(HashStructure hash) {
        super(hash);
        this.loadTemplates();
    }

    public DefaultTemplateData(URL url) {
        this(HashStructure.newInstance());
        this.setURL(url);
    }

    public static DefaultTemplateData load(URL url) throws IOException {
        HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/extension", TEMPLATE_DATA_ROOT);
        HashStructure hash = (HashStructure)io.load(url);
        DefaultTemplateData td = new DefaultTemplateData(hash);
        td.setURL(url);
        return td;
    }

    public static void save(DefaultTemplateData templateData, URL url) throws IOException {
        HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/extension", TEMPLATE_DATA_ROOT);
        io.save(url, (Object)templateData.getHashStructure());
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public void addTemplate(AbstractTemplate template) {
        String id = template.getTemplateId();
        if (id == null) {
            throw new IllegalArgumentException("Cannot register template with null id");
        }
        if (template.getTemplateClass() == null) {
            throw new IllegalArgumentException("Cannot register template with null 'templateClass' element.");
        }
        if (this.getTemplateById(id) != null) {
            return;
        }
        Iterator<Element> iter = template.getChildren();
        while (iter.hasNext()) {
            AbstractTemplate t = (AbstractTemplate)iter.next();
            if (this.findTemplateById(t.getTemplateId()) != null) continue;
            throw new IllegalStateException("Template with id=" + t.getTemplateId() + " is not registered");
        }
        this.templates_.put(template.getTemplateId(), template);
        this._hash.getOrCreateHashStructure(KEY_TEMPLATES).putHashStructure(id, template.getData());
        template.setTemplateData(this);
    }

    public void removeTemplate(AbstractTemplate template) {
        String id = template.getTemplateId();
        Assert.check((id != null ? 1 : 0) != 0);
        this.templates_.remove(id);
        this._hash.getOrCreateHashStructure(KEY_TEMPLATES).remove(id);
        Assert.check((template.getTemplateData() == this ? 1 : 0) != 0);
        template.setTemplateData(null);
    }

    @Override
    public AbstractTemplate getTemplateById(String id) {
        return this.templates_.get(id);
    }

    public void setParent(TemplateData parent) {
        this.parent_ = parent;
    }

    @Override
    public AbstractTemplate findTemplateById(String id) {
        AbstractTemplate t = this.getTemplateById(id);
        if (t == null && this.getParent() != null) {
            return this.parent_.findTemplateById(id);
        }
        return t;
    }

    @Override
    public TemplateData getParent() {
        return this.parent_;
    }

    @Override
    public List<AbstractTemplate> getAllTemplates() {
        ArrayList<AbstractTemplate> list = new ArrayList<AbstractTemplate>();
        list.addAll(this.templates_.values());
        return list;
    }

    @Override
    public <T> List<T> getTemplateByClass(Class<T> clazz) {
        ArrayList<AbstractTemplate> list = new ArrayList<AbstractTemplate>();
        for (AbstractTemplate t : this.templates_.values()) {
            if (t.getClass() != clazz) continue;
            list.add(t);
        }
        return list;
    }

    public boolean isDirty() {
        return this._hash.isDirty();
    }

    @Override
    public URL getURL() {
        return this._hash.getURL(KEY_URL);
    }

    public void setURL(URL url) {
        this._hash.putURL(KEY_URL, url);
    }

    private void loadTemplates() {
        this.templates_.clear();
        HashStructure hash = this._hash.getHashStructure(KEY_TEMPLATES);
        if (hash == null) {
            return;
        }
        for (String key : hash.keySet()) {
            AbstractTemplate t = null;
            HashStructure h = hash.getHashStructure(key);
            try {
                t = TemplateFactory.getInstance().createTemplate(h);
            }
            catch (ClassNotFoundException e) {
                TemplateUtils.logTemplateCreationException(h, e);
            }
            catch (NoSuchMethodException e) {
                TemplateUtils.logTemplateCreationException(h, e);
            }
            catch (InstantiationException e) {
                TemplateUtils.logTemplateCreationException(h, e);
            }
            catch (IllegalAccessException e) {
                TemplateUtils.logTemplateCreationException(h, e);
            }
            catch (InvocationTargetException e) {
                TemplateUtils.logTemplateCreationException(h, e);
            }
            t.setTemplateData(this);
            this.templates_.put(key, t);
        }
    }

    public Object copyTo(Object o) {
        DefaultTemplateData target = (DefaultTemplateData)super.copyTo(o);
        target.parent_ = this.parent_;
        target.loadTemplates();
        return target;
    }
}

