/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.el;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import oracle.jsp.el.OracleExpression;
import org.apache.commons.el.ArraySuffix;
import org.apache.commons.el.Coercions;
import org.apache.commons.el.ComplexValue;
import org.apache.commons.el.Constants;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.commons.el.Logger;
import org.apache.commons.el.PropertySuffix;

public class OracleExpressionEvaluator
extends ExpressionEvaluatorImpl {
    public OracleExpressionEvaluator() {
    }

    public OracleExpressionEvaluator(boolean bl) {
        super(bl);
    }

    public Object evaluate(String string, Class clazz, VariableResolver variableResolver, FunctionMapper functionMapper) throws ELException {
        return super.evaluate(string, clazz, variableResolver, functionMapper);
    }

    public Expression parseExpression(String string, Class clazz, FunctionMapper functionMapper) throws ELException {
        this.parseExpressionString(string);
        return new OracleExpression(this, string, clazz, functionMapper);
    }

    public void setValue(String string, VariableResolver variableResolver, FunctionMapper functionMapper, Object object) throws ELException {
        if (string == null) {
            throw new ELException(Constants.NULL_EXPRESSION_STRING);
        }
        Object object2 = this.parseExpressionString(string);
        if (object2 instanceof ComplexValue) {
            ComplexValue complexValue = (ComplexValue)object2;
            this.complex_value_setValue(complexValue, variableResolver, functionMapper, null, object);
        } else {
            System.out.println("No compatible type found for setValue");
        }
    }

    private void complex_value_setValue(ComplexValue complexValue, VariableResolver variableResolver, FunctionMapper functionMapper, Logger logger, Object object) throws ELException {
        org.apache.commons.el.Expression expression = complexValue.getPrefix();
        Object object2 = expression.evaluate(variableResolver, functionMapper, logger);
        List list = complexValue.getSuffixes();
        int n = 0;
        while (list != null && n < list.size()) {
            if (list.get(n) instanceof ArraySuffix) {
                ArraySuffix arraySuffix = (ArraySuffix)list.get(n);
                if (n == list.size() - 1) {
                    this.array_suffix_setValue(arraySuffix, object2, variableResolver, functionMapper, logger, object);
                } else {
                    object2 = arraySuffix.evaluate(object2, variableResolver, functionMapper, logger);
                }
            }
            ++n;
        }
    }

    private void array_suffix_setValue(ArraySuffix arraySuffix, Object object, VariableResolver variableResolver, FunctionMapper functionMapper, Logger logger, Object object2) throws ELException {
        block14: {
            Integer n;
            block18: {
                Object object3;
                block17: {
                    block16: {
                        block15: {
                            if (object != null) break block15;
                            if (!logger.isLoggingWarning()) break block14;
                            logger.logWarning(Constants.CANT_GET_INDEXED_VALUE_OF_NULL, (Object)this.getOperatorSymbol(arraySuffix));
                            break block14;
                        }
                        object3 = this.evaluateIndex(arraySuffix, variableResolver, functionMapper, logger);
                        if (object3 != null) break block16;
                        if (!logger.isLoggingWarning()) break block14;
                        logger.logWarning(Constants.CANT_GET_NULL_INDEX, (Object)this.getOperatorSymbol(arraySuffix));
                        break block14;
                    }
                    if (!(object instanceof Map)) break block17;
                    Map map = (Map)object;
                    map.put(object3, object2);
                    break block14;
                }
                if (!(object instanceof List) && !object.getClass().isArray()) break block14;
                n = Coercions.coerceToInteger((Object)object3, (Logger)logger);
                if (n != null) break block18;
                if (!logger.isLoggingError()) break block14;
                logger.logError(Constants.BAD_INDEX_VALUE, (Object)this.getOperatorSymbol(arraySuffix), (Object)object3.getClass().getName());
                break block14;
            }
            if (object instanceof List) {
                try {
                    ((List)object).set(n, object2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (logger.isLoggingWarning()) {
                        logger.logWarning(Constants.EXCEPTION_ACCESSING_LIST, (Throwable)arrayIndexOutOfBoundsException, (Object)n);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (logger.isLoggingWarning()) {
                        logger.logWarning(Constants.EXCEPTION_ACCESSING_LIST, (Throwable)indexOutOfBoundsException, (Object)n);
                    }
                }
                catch (Exception exception) {
                    if (!logger.isLoggingError()) break block14;
                    logger.logError(Constants.EXCEPTION_ACCESSING_LIST, (Throwable)exception, (Object)n);
                }
            } else {
                try {
                    Array.set(object, n, object2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (logger.isLoggingWarning()) {
                        logger.logWarning(Constants.EXCEPTION_ACCESSING_ARRAY, (Throwable)arrayIndexOutOfBoundsException, (Object)n);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (logger.isLoggingWarning()) {
                        logger.logWarning(Constants.EXCEPTION_ACCESSING_ARRAY, (Throwable)indexOutOfBoundsException, (Object)n);
                    }
                }
                catch (Exception exception) {
                    if (!logger.isLoggingError()) break block14;
                    logger.logError(Constants.EXCEPTION_ACCESSING_ARRAY, (Throwable)exception, (Object)n);
                }
            }
        }
    }

    private Object evaluateIndex(ArraySuffix arraySuffix, VariableResolver variableResolver, FunctionMapper functionMapper, Logger logger) throws ELException {
        if (arraySuffix instanceof PropertySuffix) {
            return ((PropertySuffix)arraySuffix).getName();
        }
        return arraySuffix.getIndex().evaluate(variableResolver, functionMapper, logger);
    }

    private String getOperatorSymbol(ArraySuffix arraySuffix) {
        if (arraySuffix instanceof PropertySuffix) {
            return ".";
        }
        return "[]";
    }

    private Object escapeOutput(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '<') {
                stringBuffer.append("&lt;");
            } else if (string.charAt(n) == '>') {
                stringBuffer.append("&gt;");
            } else if (string.charAt(n) == '&') {
                stringBuffer.append("&amp;");
            } else if (string.charAt(n) == '\'') {
                stringBuffer.append("&#039;");
            } else if (string.charAt(n) == '\"') {
                stringBuffer.append("&#034;");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

