/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PaletteSearch;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteAugmentedSection;
import oracle.ideimpl.palette2.PaletteWindowUI;
import oracle.ideimpl.palette2.search.SearchMatcherStrategy;
import oracle.ideimpl.palette2.search.SimpleContainsSearchStrategy;
import oracle.javatools.util.ModelUtil;

public class SearchThread
extends Thread {
    private PaletteWindowUI m_paletteWindow;
    private String m_searchPredicate;
    private volatile boolean m_abortSearch;
    private SearchMatcherStrategy m_searchMatcherStrategy;

    public SearchThread(PaletteWindowUI pWindow, String predicate) {
        super(SearchThread.class.getName());
        this.m_paletteWindow = pWindow;
        this.m_searchPredicate = predicate.toLowerCase();
        this.m_searchMatcherStrategy = new SimpleContainsSearchStrategy();
    }

    @Override
    public synchronized void start() {
        this.hideResults();
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Collection<PaletteAugmentedItem> showItems;
        Collection<PaletteAugmentedItem> resultItems = null;
        try {
            showItems = resultItems = this.getResults();
        }
        catch (Throwable throwable) {
            Collection<PaletteAugmentedItem> showItems2 = resultItems;
            Runnable runnable = new Runnable(showItems2){
                final /* synthetic */ Collection val$showItems;
                {
                    this.val$showItems = collection;
                }

                @Override
                public void run() {
                    SearchThread.this.m_paletteWindow.setSearchThread(null);
                    if (this.val$showItems == null || SearchThread.this.m_abortSearch) {
                        return;
                    }
                    SearchThread.this.m_paletteWindow.showSearchResults(this.val$showItems);
                }
            };
            SwingUtilities.invokeLater(runnable);
            throw throwable;
        }
        Runnable runnable = new /* invalid duplicate definition of identical inner class */;
        SwingUtilities.invokeLater(runnable);
    }

    private Collection<PaletteAugmentedItem> getResults() {
        ArrayList<PaletteAugmentedItem> paletteItems = new ArrayList<PaletteAugmentedItem>();
        if (this.m_paletteWindow.isSearchCancelled()) {
            return Collections.unmodifiableCollection(paletteItems);
        }
        PalettePage selectedPage = this.m_paletteWindow.getSelectedPage();
        this.getResults(selectedPage, paletteItems);
        if (this.m_paletteWindow.isSearchCancelled()) {
            return Collections.unmodifiableCollection(paletteItems);
        }
        for (PalettePages pageSet : this.m_paletteWindow.getProviderPages()) {
            for (PalettePage page : pageSet.getPages()) {
                if (page.equals(selectedPage) || ModelUtil.areEqual((Object)page.getName(), (Object)PaletteArb.getString(57))) continue;
                this.getResults(page, paletteItems);
                if (!this.m_paletteWindow.isSearchCancelled()) continue;
                return Collections.unmodifiableCollection(paletteItems);
            }
        }
        return Collections.unmodifiableCollection(paletteItems);
    }

    private void getResults(PalettePage page, List<PaletteAugmentedItem> paletteItems) {
        this.m_paletteWindow.setSearchProgress(0, 100);
        if (page != null) {
            boolean useAugmented = false;
            String pageName = page.getName();
            if (pageName.equals(PaletteArb.getString(5)) || pageName.equals(PaletteArb.getString(57))) {
                useAugmented = true;
            }
            Collection<PaletteGroup> groups = page.getGroups();
            for (PaletteGroup group : groups) {
                if (this.m_paletteWindow.isSearchCancelled()) {
                    return;
                }
                Collection<PaletteSection> sections = group.getSections();
                for (PaletteSection section : sections) {
                    PaletteAugmentedSection augSection;
                    Collection<PaletteAugmentedItem> augItems;
                    if (this.m_paletteWindow.isSearchCancelled()) {
                        return;
                    }
                    Collection<PaletteItem> items = section.getItems();
                    if (items != null) {
                        for (PaletteItem item : items) {
                            if (this.m_paletteWindow.isSearchCancelled()) {
                                return;
                            }
                            if (!this.matchesItem(item)) continue;
                            PaletteAugmentedItem augItem = new PaletteAugmentedItem(item, page.getName(), group.getName());
                            paletteItems.add(augItem);
                        }
                        continue;
                    }
                    if (!useAugmented || (augItems = (augSection = (PaletteAugmentedSection)section).getAugmentedItems(false)) == null) continue;
                    for (PaletteAugmentedItem augItem : augItems) {
                        if (this.m_paletteWindow.isSearchCancelled()) {
                            return;
                        }
                        PaletteItem item = augItem.getPaletteItem();
                        if (!this.matchesItem(item)) continue;
                        paletteItems.add(augItem);
                    }
                }
            }
        }
        this.m_paletteWindow.setSearchProgress(90, 100);
    }

    private boolean matchesItem(PaletteItem pItem) {
        String name = pItem.getName();
        if (this.m_searchMatcherStrategy.matches(this.m_searchPredicate, name)) {
            return true;
        }
        String searchTextContext = pItem.getSearchTextContext();
        if (searchTextContext != null && searchTextContext.length() > 0) {
            try {
                Object o = Class.forName(searchTextContext).newInstance();
                if (o instanceof PaletteSearch) {
                    PaletteSearch paletteSearch = (PaletteSearch)o;
                    return paletteSearch.searchItemContainsText(pItem, this.m_searchPredicate);
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private void hideResults() {
        this.m_paletteWindow.removeSearchResults();
    }

    public void abortSearch() {
        if (this.m_abortSearch) {
            this.m_paletteWindow.setSearchThread(null);
        }
        this.m_abortSearch = true;
    }
}

