/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.javatools.util.ModelUtil;

public abstract class PaletteAugmentedSection
extends PaletteSection {
    public static final String SECTION_SECTIONID = "sectiomId";
    private HashMap<Object, Object> sectionData = new HashMap();
    private List<PaletteAugmentedItem> paletteItems = new ArrayList<PaletteAugmentedItem>();
    private String name;

    protected PaletteAugmentedSection() {
    }

    protected PaletteAugmentedSection(String name, String sectionId) {
        if (ModelUtil.hasLength((String)name)) {
            this.setName(name);
        }
        if (ModelUtil.hasLength((String)sectionId)) {
            this.setData(SECTION_SECTIONID, sectionId);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getData(Object key) {
        return this.sectionData.get(key);
    }

    protected void setData(Object key, Object data) {
        this.sectionData.put(key, data);
    }

    public PaletteItem getItem(String itemId) {
        PaletteItem paletteItem = null;
        for (PaletteAugmentedItem iterItem : this.getCopyOfItemList()) {
            PaletteItem pItem = iterItem.getPaletteItem();
            String defId = pItem.getItemId();
            if (!ModelUtil.areEqual((Object)defId, (Object)itemId)) continue;
            paletteItem = pItem;
            break;
        }
        return paletteItem;
    }

    public boolean usesAugmentedItem() {
        return true;
    }

    public Collection<PaletteAugmentedItem> getAugmentedItems(boolean reverseOrder) {
        List<PaletteAugmentedItem> itemList = this.getCopyOfItemList();
        Comparator<PaletteAugmentedItem> comparator = this.getComparatorForSorting();
        if (null != comparator) {
            Collections.sort(itemList, comparator);
        }
        if (reverseOrder) {
            Collections.reverse(itemList);
        }
        return Collections.unmodifiableList(itemList);
    }

    protected List<PaletteAugmentedItem> getCopyOfItemList() {
        return new ArrayList<PaletteAugmentedItem>(this.paletteItems);
    }

    protected Comparator<PaletteAugmentedItem> getComparatorForSorting() {
        return new Comparator<PaletteAugmentedItem>(){

            @Override
            public int compare(PaletteAugmentedItem a1, PaletteAugmentedItem a2) {
                PaletteItem p1 = a1.getPaletteItem();
                PaletteItem p2 = a2.getPaletteItem();
                String s1 = p1.getName();
                String s2 = p2.getName();
                return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
            }
        };
    }

    public void addItem(PaletteItem item) {
    }

    public void addItem(PaletteItem item, String pageName, String groupName) {
        PaletteAugmentedItem found = this.findItem(item);
        if (found != null) {
            return;
        }
        PaletteAugmentedItem augItem = new PaletteAugmentedItem(item, pageName, groupName);
        this.paletteItems.add(augItem);
    }

    protected PaletteAugmentedItem findItem(PaletteItem item) {
        if (null == item) {
            return null;
        }
        for (PaletteAugmentedItem augmented : this.getCopyOfItemList()) {
            if (!this.doMatch(item, augmented.getPaletteItem())) continue;
            return augmented;
        }
        return null;
    }

    protected boolean doMatch(PaletteItem item, PaletteItem pItem) {
        return ModelUtil.areEqual((Object)item, (Object)pItem);
    }

    public void insertItem(PaletteItem item, String beforeItemId) {
    }

    public void insertItem(PaletteItem item, String pageName, String groupName, String beforeItemId) {
        PaletteAugmentedItem augItem = new PaletteAugmentedItem(item, pageName, groupName);
        boolean inserted = false;
        int idx = 0;
        for (PaletteAugmentedItem iterItem : this.getCopyOfItemList()) {
            PaletteItem pItem = iterItem.getPaletteItem();
            if (pItem.getItemId().equals(beforeItemId)) {
                this.paletteItems.add(idx, augItem);
                inserted = true;
                break;
            }
            ++idx;
        }
        if (!inserted) {
            this.addItem(item, pageName, groupName);
        }
    }

    public boolean removeItem(PaletteItem item) {
        PaletteAugmentedItem found = this.findItem(item);
        if (found != null) {
            return this.paletteItems.remove(found);
        }
        return false;
    }

    protected void removeAllItems() {
        this.paletteItems.clear();
    }

    protected static boolean areEqual(String name1, String name2) {
        boolean ret = false;
        if (name1 == null) {
            if (name2 == null) {
                ret = true;
            }
        } else if (name2 != null && name1.equalsIgnoreCase(name2)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public Collection<PaletteItem> getItems() {
        ArrayList<PaletteItem> items = new ArrayList<PaletteItem>();
        for (PaletteAugmentedItem augmentedItem : this.getAugmentedItems(false)) {
            items.add(augmentedItem.getPaletteItem());
        }
        return items;
    }

    @Override
    public boolean equals(Object that) {
        if (that != null && that instanceof PaletteAugmentedSection) {
            return this.equalsImpl((PaletteAugmentedSection)that);
        }
        return false;
    }

    private boolean equalsImpl(PaletteAugmentedSection that) {
        String thisId = (String)this.getData(SECTION_SECTIONID);
        String thatId = (String)that.getData(SECTION_SECTIONID);
        return ModelUtil.areEqual((Object)this.getName(), (Object)that.getName()) && thisId.equalsIgnoreCase(thatId);
    }
}

