/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ideimpl.palette2.MyComponentsPageProvider;
import oracle.ideimpl.palette2.PaletteArb;

public class MyComponentsCodeSnippetItem
extends DefaultPaletteItem {
    static final String PROVIDER_ID = MyComponentsPageProvider.class.getName();

    public MyComponentsCodeSnippetItem(String name, String iconUrl, String snippet) {
        String itemId = PROVIDER_ID + "." + name;
        this.setName(name);
        this.setDescription(PaletteArb.getString(12));
        this.setIcon(iconUrl);
        this.setItemId(itemId);
        this.setProviderId(PROVIDER_ID);
        this.setData("editor", "oracle.jdevimpl.palette.MyComponentsCodeSnippetTransferable");
        this.setData("codeSnippet", snippet);
    }

    public void updateCodeSnippet(String iconUrl, String snippet) {
        this.setIcon(iconUrl);
        this.setData("codeSnippet", snippet);
    }

    @Override
    public String getDescription() {
        String snippet = null;
        String text = (String)this.getData("codeSnippet");
        if (text != null) {
            boolean appendElipse = false;
            int len = text.length();
            if (len > 0) {
                if (len > 50) {
                    len = 50;
                    appendElipse = true;
                }
                snippet = text.substring(0, len);
                if (appendElipse) {
                    snippet = snippet + "...";
                }
            }
        }
        return snippet;
    }
}

