/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ideimpl.palette2.DeclaredExtension;
import oracle.ideimpl.palette2.DeclaredItem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class DeclaredSection
extends HashStructureAdapter
implements DeclaredExtension {
    public DeclaredSection(HashStructure hash) {
        super(hash);
    }

    public static DeclaredSection getInstance(HashStructure hash) {
        return new DeclaredSection(hash);
    }

    public String getName() {
        return this._hash.getString("name/#text");
    }

    public String getSectionId() {
        return this._hash.getString("sectionId/#text");
    }

    public Collection<DeclaredItem> getItems() {
        List data = this._hash.getAsList("item");
        if (data != null) {
            ArrayList<DeclaredItem> items = new ArrayList<DeclaredItem>(data.size());
            for (HashStructure h : data) {
                items.add(DeclaredItem.getInstance(h));
            }
            return Collections.unmodifiableList(items);
        }
        return null;
    }

    public String toString() {
        String temp = String.format("DeclaredSection[ name=%s, sectionId=%s ] \n", String.valueOf(this.getName()), String.valueOf(this.getSectionId()));
        Collection<DeclaredItem> items = this.getItems();
        for (DeclaredItem x : items) {
            temp = temp + x.toString();
        }
        return temp;
    }

    @Override
    public String getExtensionId() {
        return this._hash.getString("#__extension-id");
    }

    public static class SectionBuilder
    extends DefaultPaletteSection.Builder {
        public SectionBuilder(DeclaredSection section) {
            super(section.getName(), section.getSectionId());
            this.extensionId(section.getExtensionId());
        }
    }
}

