/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.AllPagesSection;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteWindowImpl;

public class AllPages
extends PalettePages {
    private List<PalettePage> palettePages = new ArrayList<PalettePage>();
    private static AllPages _singleton = new AllPages();
    private DefaultPalettePage palettePage;
    private DefaultPaletteGroup paletteGroup;
    private AllPagesSection paletteSection;

    public AllPages() {
        String pageId = this.getClass().getName();
        this.palettePage = new DefaultPalettePage(PaletteArb.getString(57), PaletteArb.getString(58), null, pageId);
        String groupId = pageId + ".Group";
        this.paletteGroup = new DefaultPaletteGroup(PaletteArb.getString(59), PaletteArb.getString(60), null, groupId, null, null, null, null, "AllPages");
        this.palettePage.addGroup(this.paletteGroup);
        String sectionId = groupId + ".Section";
        this.paletteSection = new AllPagesSection("", sectionId);
        this.paletteGroup.addSection(this.paletteSection);
        this.palettePages.add(this.palettePage);
    }

    public static AllPages getInstance() {
        return _singleton;
    }

    @Override
    public Collection<PalettePage> getPages() {
        this.paletteSection.removeAllItems();
        List<PalettePages> providerPages = ((PaletteWindowImpl)PaletteWindowImpl.getInstance()).getProviderPages();
        for (PalettePages providerPage : providerPages) {
            Collection<PalettePage> pPages = providerPage.getPages();
            for (PalettePage pPage : pPages) {
                if (pPage.getName().equals(PaletteArb.getString(5))) continue;
                Collection<PaletteGroup> pGroups = pPage.getGroups();
                for (PaletteGroup pGroup : pGroups) {
                    Collection<PaletteSection> pSections = pGroup.getSections();
                    for (PaletteSection pSection : pSections) {
                        Collection<PaletteItem> pItems = pSection.getItems();
                        for (PaletteItem pItem : pItems) {
                            this.paletteSection.addItem(pItem, pPage.getName(), pGroup.getName());
                        }
                    }
                }
            }
        }
        return Collections.unmodifiableList(this.palettePages);
    }

    @Override
    public PaletteItem getItem(String providerId, String itemId) {
        return null;
    }

    @Override
    public void addPalettePagesListener(PalettePagesListener listener) {
    }

    @Override
    public void removePalettePagesListener(PalettePagesListener listener) {
    }
}

