/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2.layouts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.extension.ElementName;
import javax.swing.Icon;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.extension.HashStructureHookAggregator;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.palette2.layouts.PaletteLayout;
import oracle.javatools.data.HashStructure;

public interface PaletteLayoutDescriptor {
    public String id();

    public String name();

    public String description();

    public Icon icon();

    public PaletteLayout getLayoutInstance();

    public static class Manager {
        private static final String LAYOUT_EL_NAME = "layout";
        private static final String HOOK_ID = "palette-layouts-hook";
        private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "palette-layouts-hook");
        private static final Map<String, PaletteLayoutDescriptor> DESCRIPTORS_BY_ID = new HashMap<String, PaletteLayoutDescriptor>();
        private static final HashStructureHookAggregator AGGREGATOR = new HashStructureHookAggregator(HOOK_NAME, new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                Manager.addLayoutDescriptors(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                Manager.addLayoutDescriptors(e.getCombinedHashStructure());
            }
        });

        public static void addLayoutDescriptor(PaletteLayoutDescriptor descriptor) {
            if (null == descriptor) {
                return;
            }
            DESCRIPTORS_BY_ID.put(descriptor.id(), descriptor);
        }

        public static PaletteLayoutDescriptor getLayoutDescriptor(String id) {
            AGGREGATOR.initialize();
            return DESCRIPTORS_BY_ID.get(id);
        }

        public static List<PaletteLayoutDescriptor> getLayoutDescriptors() {
            AGGREGATOR.initialize();
            return new ArrayList<PaletteLayoutDescriptor>(DESCRIPTORS_BY_ID.values());
        }

        public static Set<String> getLayoutDescriptorKeys() {
            AGGREGATOR.initialize();
            return Collections.unmodifiableSet(DESCRIPTORS_BY_ID.keySet());
        }

        private static void addLayoutDescriptors(HashStructure hash) {
            if (null == hash) {
                return;
            }
            List list = hash.getAsList(LAYOUT_EL_NAME);
            for (Object obj : list) {
                PaletteLayoutDescriptor descriptor = (PaletteLayoutDescriptor)AdapterManager.Factory.getAdapterManager().adapt(obj, PaletteLayoutDescriptor.class);
                Manager.addLayoutDescriptor(descriptor);
            }
        }
    }
}

