/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.credential;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.util.credential.CredentialArb;
import oracle.dbtools.util.credential.CredentialCodeGenerator;
import oracle.dbtools.util.credential.IdentifierImpl;

public class DropAction
extends ActionDialog {
    private static final String FORCE = "force";
    private static final String OWNER = "owner";
    private static final String NAME = "name";
    private static final String DROP_MESSAGE = "drop_message";
    String owner = null;
    String name = null;
    boolean force = false;
    String objectType = null;
    boolean useForce = false;

    public DropAction() {
        this.setScriptEditingEnabled(false);
    }

    @Override
    protected String getTitle() {
        return CredentialArb.getString("DROP_DIALOG_TITLE" + (String)(this.objectType == null ? "" : "_" + this.objectType));
    }

    @Override
    protected String getQuery(Connection connection, String string) {
        String string2 = RaptorVersionTracker.getDbVersion(connection).toCanonicalString();
        CredentialCodeGenerator credentialCodeGenerator = CredentialCodeGenerator.getInstance();
        return credentialCodeGenerator.generate(string2, string, null);
    }

    @Override
    protected List<ActionControl> createControls(Connection connection) {
        String string;
        try {
            string = this.getObjectName();
        }
        catch (Exception exception) {
            string = "null";
        }
        try {
            String string2 = this.getDBObjectSchemaName();
            if (string2 == null) {
                string2 = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception exception) {
            String string3 = "null";
        }
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = null;
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(NAME, CredentialArb.getString("DROP_DIALOG_NAME" + (String)(this.objectType == null ? "" : "_" + this.objectType)), string);
        LabelActionControl labelActionControl = new LabelActionControl(DROP_MESSAGE, CredentialArb.getString("DROP_DIALOG_MSG" + (String)(this.objectType == null ? "" : "_" + this.objectType)));
        textBoxActionControl.setEditable(false);
        arrayList.add(textBoxActionControl);
        if (this.useForce) {
            booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(FORCE, CredentialArb.getString("DROP_FORCE_LABEL"), this.force);
            arrayList.add(booleanCheckBoxActionControl);
        }
        arrayList.add(labelActionControl);
        return arrayList;
    }

    @Override
    protected String getScript(ActionDialog.Values values) {
        Object object;
        String string = this.getDBObject().getDBVersion();
        CredentialCodeGenerator credentialCodeGenerator = CredentialCodeGenerator.getInstance();
        String string2 = values.get(OWNER);
        String string3 = values.get(NAME);
        String string4 = values.get(FORCE);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string2 != null) {
            string2 = string2.trim();
            object = new IdentifierImpl(string2);
            string2 = ((IdentifierImpl)object).getId();
        }
        if (string3 != null) {
            string3 = string3.trim();
            object = new IdentifierImpl(string3);
            string3 = ((IdentifierImpl)object).getId();
        }
        object = new TreeMap<String, String>();
        object.put(OWNER, string2);
        object.put(NAME, string3);
        object.put(FORCE, string4 == null ? false : Boolean.valueOf(string4));
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(OWNER, DropAction.equals(string2, this.owner) == false);
        treeMap.put(NAME, DropAction.equals(string3, this.name) == false);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", object);
        treeMap2.put("changes", treeMap);
        String string5 = null;
        try {
            string5 = credentialCodeGenerator.generate(string, this.objectType + "_DROP", treeMap2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string5;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    @Override
    public void launch() {
        try {
            super.launch();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setArgs(String string) {
        String[] stringArray;
        super.setArgs(string);
        if (string != null && (stringArray = string.split(",")) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = stringArray[i].trim();
            }
            if (stringArray.length > 0) {
                this.objectType = stringArray[0];
            }
            this.useForce = stringArray.length > 1 && stringArray[1].equalsIgnoreCase(FORCE);
        }
    }

    @Override
    protected boolean isCloseOnError() {
        return false;
    }
}

