/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.db.LockManager;

public abstract class ContainerExecutor<T> {
    private static final String CONTAINER_QUERY = "SELECT SYS_CONTEXT('USERENV', 'CON_NAME') FROM DUAL";
    private static final String ALTER_STUB = "ALTER SESSION SET CONTAINER = ";
    private final Connection mConnection;
    private T mResult;

    public ContainerExecutor(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("null connection");
        }
        this.mConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean runInContainer(String string, boolean bl) throws SQLException {
        boolean bl2;
        block9: {
            bl2 = false;
            if (string == null) {
                throw new IllegalArgumentException("null container");
            }
            this.clearResult();
            boolean bl3 = LockManager.checkLock((Connection)this.mConnection);
            if (bl3 || LockManager.lock((Connection)this.mConnection, (boolean)bl)) {
                try {
                    String string2 = this.getCurrentContainer();
                    if (string2 == null) break block9;
                    this.setContainer(string);
                    try {
                        this.setResult(this.runImpl());
                        bl2 = true;
                    }
                    finally {
                        this.setContainer(string2);
                    }
                }
                finally {
                    if (!bl3) {
                        LockManager.unlock((Connection)this.mConnection);
                    }
                }
            }
        }
        return bl2;
    }

    private void setResult(T t) {
        this.mResult = t;
    }

    private void clearResult() {
        this.mResult = null;
    }

    public final T getResult() {
        return this.mResult;
    }

    protected abstract T runImpl() throws SQLException;

    private String getCurrentContainer() throws SQLException {
        String string = null;
        try (PreparedStatement preparedStatement = this.mConnection.prepareStatement(CONTAINER_QUERY);
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        return string;
    }

    private void setContainer(String string) throws SQLException {
        String string2 = ALTER_STUB + string;
        try (PreparedStatement preparedStatement = this.mConnection.prepareStatement(string2);){
            preparedStatement.execute();
        }
    }
}

