/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Messages;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.javatools.db.DBException;

public class ClosedConnectionListener
implements SQLExceptionListener {
    public boolean handleSQLError(final String string, final SQLException sQLException) {
        int n = sQLException.getErrorCode();
        switch (n) {
            case 1012: 
            case 2396: 
            case 2399: 
            case 17008: {
                try {
                    boolean bl = false;
                    if (Connections.getInstance().checkLock(string)) {
                        Connections.getInstance().unlock(string);
                        bl = true;
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ClosedConnectionListener.this.reconnect(string, sQLException);
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    if (bl) {
                        Connections.getInstance().lock(string);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    public void reconnect(String string, SQLException sQLException) {
        String string2 = "ORA-" + sQLException.getErrorCode() + Messages.getString("ClosedConnectionListener.1");
        if (ExceptionHandler.handleExceptionWithAction((Exception)sQLException, (String)string2, (String)Messages.getString("ClosedConnectionListener.2"), null)) {
            Connections.getInstance().closeConnection(string, true);
            try {
                Connections.getInstance().getConnection(string, true);
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
    }
}

