/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;

public class TableActionControl
extends ActionControl {
    private TableActionControlPanel _ui;
    private JTable _table;
    private TableActionControlModel _model;
    private int _visibleRows;
    private RowFactory _rowFactory;
    private TablePanelController tablePanelController = new TablePanelController();
    private boolean showShuttleButtons = false;
    private int buttonMask = 0;
    private CellFormat _cellFormat;

    public TableActionControl(String string, List<String> list, List<? extends Row> list2, int n) {
        this(string, null, null, list, list2, n);
    }

    public TableActionControl(String string, String string2, List<String> list, List<? extends Row> list2, int n) {
        this(string, string2, null, list, list2, n);
    }

    public TableActionControl(String string, String string2, RowFactory rowFactory, List<String> list, List<? extends Row> list2, int n) {
        this(string, string2, rowFactory, list, list2, n, false);
    }

    public TableActionControl(String string, String string2, RowFactory rowFactory, List<String> list, List<? extends Row> list2, int n, boolean bl) {
        super(string, string2);
        this._rowFactory = rowFactory;
        this._visibleRows = n;
        this.showShuttleButtons = bl;
        this._model = new TableActionControlModel(list, list2);
        this._ui = new TableActionControlPanel(this._model, this.tablePanelController, n);
        this.setSpringVertical(true);
        this.setFillVertical(true);
        this._ui.setName("tableActionControlUI");
        this._table = this._ui.getTable();
        this._table.setColumnSelectionAllowed(true);
        this._table.setRowSelectionAllowed(true);
        this._table.setSelectionMode(0);
        if (bl) {
            this.buttonMask = 60;
        }
        if (this._rowFactory != null) {
            this.buttonMask |= 3;
        }
        this._ui.setButtons(this.buttonMask);
    }

    public void setCellFormat(CellFormat cellFormat) {
        this._cellFormat = cellFormat;
    }

    public void setRows(List<? extends Row> list) {
        this._model.setRows(list);
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        List<String> list = this._model.getColumnNames();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Row row : this._model.getRows()) {
                arrayList.add(row.getValue(i));
            }
            value.addList(string, arrayList);
        }
        return value;
    }

    @Override
    public Component getUI() {
        return this._ui;
    }

    @Override
    public void setEditable(boolean bl) {
        this._ui.setEnabled(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        this.setEditable(bl);
    }

    public void setShowShuttleButtons(boolean bl) {
        this.showShuttleButtons = bl;
        this.buttonMask = bl ? (this.buttonMask |= 0x3C) : (this.buttonMask &= 0xFFFFFFC3);
        this._ui.setButtons(this.buttonMask);
    }

    public boolean isShowShuttleButtons() {
        return this.showShuttleButtons;
    }

    public int getButtonMask() {
        return this.buttonMask;
    }

    public void setTitle(String string) {
        this._ui.setTitle(string);
    }

    private class TableActionControlModel
    extends AbstractTableModel {
        private List<String> _columnNames;
        private transient ArrayList<Row> _rows;

        public TableActionControlModel(List<String> list, List<? extends Row> list2) {
            this._columnNames = list;
            this._rows = new ArrayList<Row>(list2);
        }

        public List<String> getColumnNames() {
            return this._columnNames;
        }

        public List<Row> getRows() {
            return this._rows;
        }

        public void addRow(Row row) {
            this._rows.add(row);
            this.fireTableDataChanged();
        }

        public void addRow(int n, Row row) {
            this._rows.add(n, row);
            this.fireTableDataChanged();
        }

        public void removeRow(Row row) {
            this._rows.remove(row);
            this.fireTableDataChanged();
        }

        public void removeRow(int n) {
            this._rows.remove(n);
            this.fireTableDataChanged();
        }

        public void setRows(List<? extends Row> list) {
            this._rows = new ArrayList<Row>(list);
            this.fireTableStructureChanged();
        }

        public void moveSelectionToFirst() {
            Row row = null;
            int n = TableActionControl.this._table.getSelectedRow();
            int n2 = TableActionControl.this._table.getSelectedColumn();
            if (n > 0) {
                List<Row> list = this.getRows();
                row = list.get(n);
                this.removeRow(row);
                this.addRow(0, row);
                TableActionControl.this._table.changeSelection(0, n2, false, false);
            }
        }

        public void moveSelectionToPrevious() {
            Row row = null;
            int n = TableActionControl.this._table.getSelectedRow();
            int n2 = TableActionControl.this._table.getSelectedColumn();
            if (n > 0) {
                List<Row> list = this.getRows();
                row = list.get(n);
                this.removeRow(row);
                this.addRow(n - 1, row);
                TableActionControl.this._table.changeSelection(n - 1, n2, false, false);
            }
        }

        public void moveSelectionToNext() {
            Row row = null;
            int n = TableActionControl.this._table.getSelectedRow();
            int n2 = TableActionControl.this._table.getSelectedColumn();
            List<Row> list = this.getRows();
            if (n >= 0 && n < list.size() - 1) {
                row = list.get(n);
                this.removeRow(row);
                this.addRow(n + 1, row);
                TableActionControl.this._table.changeSelection(n + 1, n2, false, false);
            }
        }

        public void moveSelectionToLast() {
            Row row = null;
            int n = TableActionControl.this._table.getSelectedRow();
            int n2 = TableActionControl.this._table.getSelectedColumn();
            List<Row> list = this.getRows();
            if (n >= 0 && n < list.size() - 1) {
                row = list.get(n);
                this.removeRow(row);
                this.addRow(list.size(), row);
                TableActionControl.this._table.changeSelection(list.size() - 1, n2, false, false);
            }
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames.get(n).toString();
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this._rows.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this._rows.get(n).isValueEditable(n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (TableActionControl.this._cellFormat != null) {
                object = TableActionControl.this._cellFormat.format(object, n2);
            }
            this._rows.get(n).setValue(n2, object.toString());
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this._rows.get(n).getValue(n2);
        }
    }

    private class TablePanelController
    implements TableActionControlPanel.TableActionControlPanelController {
        private TablePanelController() {
        }

        @Override
        public void addButtonPressed(ActionEvent actionEvent) {
            Row row = null;
            int n = TableActionControl.this._table.getSelectedRow();
            if (n >= 0) {
                row = TableActionControl.this._model.getRows().get(n);
            }
            Row row2 = TableActionControl.this._rowFactory.createRow(n, row);
            if (n >= 0) {
                TableActionControl.this._model.addRow(n + 1, row2);
            } else {
                TableActionControl.this._model.addRow(row2);
            }
        }

        @Override
        public void removeButtonPressed(ActionEvent actionEvent) {
            int n = TableActionControl.this._table.getSelectedRow();
            if (n >= 0) {
                TableActionControl.this._model.removeRow(n);
            }
        }

        @Override
        public void firstButtonPressed(ActionEvent actionEvent) {
            TableActionControl.this._model.moveSelectionToFirst();
        }

        @Override
        public void previousButtonPressed(ActionEvent actionEvent) {
            TableActionControl.this._model.moveSelectionToPrevious();
        }

        @Override
        public void nextButtonPressed(ActionEvent actionEvent) {
            TableActionControl.this._model.moveSelectionToNext();
        }

        @Override
        public void lastButtonPressed(ActionEvent actionEvent) {
            TableActionControl.this._model.moveSelectionToLast();
        }
    }

    public static interface CellFormat {
        public Object format(Object var1, int var2);
    }

    public static interface Row {
        public String getValue(int var1);

        public boolean isValueEditable(int var1);

        public void setValue(int var1, String var2);
    }

    public static interface RowFactory {
        public Row createRow(int var1, Row var2);
    }
}

