/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.ide.Ide;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.ora.Oracle12cR2;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class NameBoxActionControl
extends ActionControl {
    private JFormattedTextField _field;
    private String _defaultValue;
    private String lastValue;

    public static Format getIntegerFormat() {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    public static Format getDateFormat() {
        DateFormat dateFormat = DateFormat.getDateInstance();
        return dateFormat;
    }

    public NameBoxActionControl(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public NameBoxActionControl(String string, String string2, String string3, Format format) {
        this(string, string2, string3, format, false);
    }

    public NameBoxActionControl(final String string, String string2, String string3, Format format, boolean bl) {
        super(string, string2);
        this._defaultValue = string3;
        this._field = format != null ? new JFormattedTextField(format) : new JFormattedTextField();
        this._field.setName(string);
        this.reset();
        if (bl) {
            this._field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    NameBoxActionControl.this.firePropertyChangeListeners(string);
                }
            });
        } else {
            this._field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    NameBoxActionControl.this.firePropertyChangeListeners();
                }
            });
        }
        this._field.setInputVerifier(new DBNameVerifier());
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        String string = this._field.getText();
        value.set(string);
        this.lastValue = string;
        return value;
    }

    @Override
    public Component getUI() {
        return this._field;
    }

    public void set(String string) {
        String string2 = this._field.getText();
        if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
            this._field.setText(string);
        }
    }

    @Override
    public void reset() {
        this.set(this._defaultValue);
    }

    @Override
    public void setEditable(boolean bl) {
        this._field.setEditable(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        super.enableUI(bl);
        this._field.setEnabled(bl);
    }

    private static class DBNameVerifier
    extends InputVerifier {
        private DBNameVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            String string = ((JTextComponent)jComponent).getText();
            if (string != null && !string.equals("")) {
                if (!(string = string.trim()).startsWith("\"")) {
                    DatabaseDescriptor databaseDescriptor = DatabaseFactory.getDatabaseDescriptor(Oracle12cR2.class);
                    if (!((OracleDatabaseDescriptor)databaseDescriptor).isValidOracleIdentifier(string, false)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("INVALID_NAME"), string), (String)UiResources.getString("ERROR_TITLE"), null);
                        bl = false;
                    }
                } else {
                    int n = string.substring(1).indexOf("\"");
                    if (n >= 0 && n < string.length() - 2) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("INVALID_NAME"), string), (String)UiResources.getString("ERROR_TITLE"), null);
                        bl = false;
                    }
                }
            }
            return bl;
        }
    }
}

