/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBoxLoader;
import oracle.dbtools.util.Logger;

public class DelayedLoadingComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private static final String LOADED_KEY = "DelayedLoadingComboBox-loaded";
    DelayedLoadingComboBoxLoader _loader;
    private Object currentValue;

    public DelayedLoadingComboBox(String string, Object object, DelayedLoadingComboBoxLoader delayedLoadingComboBoxLoader) {
        this(string, object, delayedLoadingComboBoxLoader, false);
    }

    public DelayedLoadingComboBox(String string, Object object, DelayedLoadingComboBoxLoader delayedLoadingComboBoxLoader, boolean bl) {
        assert (string != null);
        assert (object != null);
        assert (delayedLoadingComboBoxLoader != null);
        this.setName(string);
        this.getEditor().getEditorComponent().setName(string + "_Editor");
        this._loader = delayedLoadingComboBoxLoader;
        this.init(object, bl);
    }

    private void init(Object object, boolean bl) {
        this.setModel(new DefaultComboBoxModel<Object>(new Object[]{object}));
        this.setSelectedItem(object);
        this.addPopupMenuListener(new PopupListener());
        this._loader.init(this, object);
        if (bl) {
            this.startLoader();
        }
    }

    private void startLoader() {
        this.startLoader(false);
    }

    private void startLoader(boolean bl) {
        if (bl) {
            this._loader.addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            DelayedLoadingComboBox.this.showPopup();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
        }
        this._loader.start();
    }

    void populate(List<Object> list, Object object) {
        assert (list != null);
        Object object2 = this.getCurrentValue();
        if (!list.contains(object2)) {
            try {
                list.add(0, object2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Logger.ignore(this.getClass(), (Throwable)unsupportedOperationException);
            }
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.setModel(defaultComboBoxModel);
        this.putClientProperty(LOADED_KEY, Boolean.TRUE);
        int n = Math.max(0, defaultComboBoxModel.getIndexOf(object2));
        this.setSelectedIndex(n);
    }

    @Override
    public void setSelectedItem(Object object) {
        if (!Boolean.TRUE.equals(this.getClientProperty(LOADED_KEY))) {
            this.setModel(new DefaultComboBoxModel<Object>(new Object[]{object}));
        }
        this.setSelectedItemSuper(object);
        this.setCurrentValue(object);
    }

    private void setSelectedItemSuper(Object object) {
        super.setSelectedItem(object);
    }

    private void setCurrentValue(Object object) {
        this.currentValue = object;
    }

    private Object getCurrentValue() {
        return this.currentValue;
    }

    private class PopupListener
    implements PopupMenuListener {
        private PopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            if (!Boolean.TRUE.equals(DelayedLoadingComboBox.this.getClientProperty(DelayedLoadingComboBox.LOADED_KEY))) {
                DelayedLoadingComboBox.this.removeAllItems();
                String string = UiResources.get("DelayedLoadingComboBox_LOADING_MSG");
                DelayedLoadingComboBox.this.addItem(string);
                DelayedLoadingComboBox.this.setSelectedItemSuper(string);
                DelayedLoadingComboBox.this.removePopupMenuListener(this);
                DelayedLoadingComboBox.this.startLoader(true);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

