/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.status;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collections;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.status.MemoryPanel;
import oracle.dbtools.raptor.status.StatusNode;
import oracle.dbtools.raptor.status.StatusPanelArb;
import oracle.dbtools.raptor.status.TableSpacePanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;

class StatusPanel {
    public static final String STATUS_NAME = "raptor.StatusPanel";
    public static final int STATUS_ACTION = Ide.findOrCreateCmdID((String)"raptor.StatusPanel");
    private TableSpacePanel tp;
    private MemoryPanel mp;
    private JPanel jp = new JPanel();
    private String dba_sql;
    private String up_sql;
    private StatusNode mNode;
    final IDelayedProgressRunnable stopDb = new IDelayedProgressRunnable(){

        @Override
        public void cancel() {
        }

        @Override
        public Object doWork() {
            StatusPanel.this.shutdown();
            StatusPanel.this.refresh();
            return true;
        }

        @Override
        public void finish(Object object) {
        }

        @Override
        public void preWork() {
        }
    };
    final IDelayedProgressRunnable startDb = new IDelayedProgressRunnable(){

        @Override
        public void cancel() {
        }

        @Override
        public Object doWork() {
            StatusPanel.this.startup();
            StatusPanel.this.refresh();
            return true;
        }

        @Override
        public void finish(Object object) {
        }

        @Override
        public void preWork() {
        }
    };

    StatusPanel() {
    }

    private void shutdown() {
        try {
            Properties properties = Connections.getInstance().getConnectionInfo(this.mNode.getConnName());
            String string = properties.getProperty("customUrl");
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            OracleDataSource oracleDataSource = new OracleDataSource();
            Properties properties2 = new Properties();
            properties2.setProperty("user", string2);
            properties2.setProperty("password", string3);
            properties2.setProperty("internal_logon", Messages.getString("StatusPanel.6"));
            oracleDataSource.setConnectionProperties(properties2);
            oracleDataSource.setURL(string);
            OracleConnection oracleConnection = (OracleConnection)oracleDataSource.getConnection();
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.IMMEDIATE);
            Statement statement = oracleConnection.createStatement();
            statement.executeUpdate("ALTER DATABASE CLOSE NORMAL");
            statement.executeUpdate("ALTER DATABASE DISMOUNT");
            statement.close();
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
            oracleConnection.close();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void startup() {
        try {
            Properties properties = Connections.getInstance().getConnectionInfo(this.mNode.getConnName());
            String string = properties.getProperty("customUrl");
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            OracleDataSource oracleDataSource = new OracleDataSource();
            Properties properties2 = new Properties();
            properties2.setProperty("user", string2);
            properties2.setProperty("password", string3);
            properties2.setProperty("internal_logon", "sysdba");
            properties2.setProperty("prelim_auth", "true");
            oracleDataSource.setConnectionProperties(properties2);
            oracleDataSource.setURL(string);
            OracleConnection oracleConnection = (OracleConnection)oracleDataSource.getConnection();
            oracleConnection.startup(OracleConnection.DatabaseStartupMode.NO_RESTRICTION);
            oracleConnection.close();
            OracleDataSource oracleDataSource2 = new OracleDataSource();
            Properties properties3 = new Properties();
            properties3.setProperty("user", string2);
            properties3.setProperty("password", string3);
            properties3.setProperty("internal_logon", "sysdba");
            oracleDataSource2.setConnectionProperties(properties3);
            oracleDataSource2.setURL(string);
            OracleConnection oracleConnection2 = (OracleConnection)oracleDataSource2.getConnection();
            Statement statement = oracleConnection2.createStatement();
            statement.executeUpdate("ALTER DATABASE MOUNT");
            statement.executeUpdate("ALTER DATABASE OPEN");
            statement.close();
            oracleConnection2.close();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void setupSql(OracleConnection oracleConnection) {
        if (this.up_sql == null) {
            QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(this.getClass().getClassLoader(), "/oracle/dbtools/raptor/status/StatusSql.xml"));
            Query query = queryXMLSupport.getQuery("reg_dba", (Connection)oracleConnection);
            this.dba_sql = query.getSql();
            query = queryXMLSupport.getQuery("is_up", (Connection)oracleConnection);
            this.up_sql = query.getSql();
        }
    }

    private boolean isSysDba(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null) {
            String string2 = properties.getProperty("role");
            return "SYSDBA".equals(string2);
        }
        return false;
    }

    private boolean isOracle(String string) {
        return Connections.getInstance().isOracle(string);
    }

    private boolean isDba(OracleConnection oracleConnection) {
        DBUtil dBUtil = DBUtil.getInstance((Connection)oracleConnection);
        dBUtil.setRaiseError(false);
        String string = dBUtil.executeReturnOneCol(this.dba_sql, Collections.emptyList());
        dBUtil.setRaiseError(true);
        return "YES".equals(string);
    }

    private boolean isUp(OracleConnection oracleConnection) {
        DBUtil dBUtil = DBUtil.getInstance((Connection)oracleConnection);
        dBUtil.setRaiseError(false);
        String string = dBUtil.executeReturnOneCol(this.up_sql, Collections.emptyList());
        dBUtil.setRaiseError(true);
        return "YES".equals(string);
    }

    JPanel getPanel() {
        return this.jp;
    }

    void setNode(StatusNode statusNode) {
        if (this.mNode != statusNode) {
            this.mNode = statusNode;
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        String string;
        this.jp.removeAll();
        this.jp.setLayout(new GridBagLayout());
        String string2 = string = this.mNode != null ? this.mNode.getConnName() : null;
        if (this.mNode == null || !this.isOracle(string)) {
            this.jp.add((Component)new JLabel(StatusPanelArb.getString("ORACLE_ONLY")), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        try {
            ConnectionSelectorUI.SELECTOR_ACTIVE = true;
            OracleConnection oracleConnection = (OracleConnection)Connections.getInstance().getConnection(string);
            this.setupSql(oracleConnection);
            if (this.isUp(oracleConnection)) {
                JButton jButton;
                if (this.isDba(oracleConnection)) {
                    this.mp = new MemoryPanel((Connection)oracleConnection);
                    this.jp.add((Component)this.mp.getPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
                    this.tp = new TableSpacePanel(string);
                    this.jp.add((Component)this.tp.getPanel(), new GridBagConstraints(0, 1, 3, 1, 0.1, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
                    jButton = new JButton(Messages.getString("StatusPanel.5"));
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            StatusPanel.this.tp.refresh();
                            StatusPanel.this.mp.refresh();
                        }
                    });
                    this.jp.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 20, 0, 0), 0, 0));
                } else {
                    this.jp.add((Component)new JLabel(StatusPanelArb.getString("NOT_DBA")), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                }
                if (this.isSysDba(string)) {
                    jButton = new JButton(Messages.getString("StatusPanel.28"));
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable(Messages.getString("StatusPanel.29"), null, 500, StatusPanel.this.stopDb);
                                    delayedProgressRunnable.setCancellable(false);
                                    delayedProgressRunnable.start();
                                }
                            });
                        }
                    });
                    this.jp.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 5, 0, 0), 0, 0));
                }
            } else if (this.isSysDba(string)) {
                JButton jButton = new JButton("Startup");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable(Messages.getString("StatusPanel.31"), null, 500, StatusPanel.this.startDb);
                                delayedProgressRunnable.setCancellable(false);
                                delayedProgressRunnable.start();
                            }
                        });
                    }
                });
                this.jp.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.jp.add((Component)new JLabel(StatusPanelArb.getString("DB_DOWN")), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        catch (Exception exception) {
            if (this.isSysDba(string)) {
                JButton jButton = new JButton(Messages.getString("StatusPanel.32"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable(Messages.getString("StatusPanel.33"), null, 500, StatusPanel.this.startDb);
                                delayedProgressRunnable.setCancellable(false);
                                delayedProgressRunnable.start();
                            }
                        });
                    }
                });
                this.jp.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.jp.add((Component)new JLabel(StatusPanelArb.getString("DB_DOWN")), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        finally {
            ConnectionSelectorUI.SELECTOR_ACTIVE = false;
        }
    }
}

