/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;

abstract class QueryWrapper {
    private static final QueryXMLSupport ORACLE_QUERIES;
    private static final QueryXMLSupport X10_QUERIES;
    private static final Map<Connection, QueryWrapper> WRAPPERS;
    protected final Connection mConn;
    private final Map<String, Query> m_queries = new HashMap<String, Query>();

    public static QueryWrapper getQueryWrapper(Connection connection) {
        QueryWrapper queryWrapper = WRAPPERS.get(connection);
        if (queryWrapper == null) {
            if (Connections.getInstance().isOracle(connection)) {
                queryWrapper = new OracleQueryWrapper(connection);
            } else if (Connections.getInstance().isTimesTen(connection)) {
                queryWrapper = new X10QueryWrapper(connection);
            } else {
                throw new IllegalArgumentException("Unknown connections class: " + connection.getClass());
            }
            WRAPPERS.put(connection, queryWrapper);
        }
        return queryWrapper;
    }

    protected static final Query getQuery(QueryXMLSupport queryXMLSupport, String string, Connection connection) {
        return queryXMLSupport.getQuery(string, connection);
    }

    private QueryWrapper(Connection connection) {
        this.mConn = connection;
    }

    public Query getQuery(String string) {
        Query query = this.m_queries.get(string);
        if (query == null) {
            query = this.findQuery(string);
            this.m_queries.put(string, query);
        }
        return query;
    }

    protected abstract Query findQuery(String var1);

    static {
        ClassLoader classLoader = QueryWrapper.class.getClassLoader();
        ORACLE_QUERIES = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(classLoader, "/oracle/dbtools/raptor/runner/source.xml"));
        X10_QUERIES = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(classLoader, "/oracle/dbtools/raptor/runner/x10source.xml"));
        WRAPPERS = new WeakHashMap<Connection, QueryWrapper>();
    }

    private static class X10QueryWrapper
    extends QueryWrapper {
        X10QueryWrapper(Connection connection) {
            super(connection);
        }

        @Override
        protected Query findQuery(String string) {
            Query query = X10_QUERIES.getQuery(string, this.mConn);
            if (query == null) {
                query = ORACLE_QUERIES.getQuery(string, this.mConn);
            }
            return query;
        }
    }

    private static class OracleQueryWrapper
    extends QueryWrapper {
        OracleQueryWrapper(Connection connection) {
            super(connection);
        }

        @Override
        protected Query findQuery(String string) {
            return ORACLE_QUERIES.getQuery(string, this.mConn);
        }
    }
}

