/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.RefactorMenu;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.util.Pair;

public class Surrounder {
    String selection = null;
    int start;
    int end;
    Map<Integer, Pair> wrappers = new HashMap<Integer, Pair>();

    public Surrounder() {
        this.wrappers.put(RefactorMenu.cmdFOR, new Pair((Object)"FOR x IN 1..n LOOP\n", (Object)"END LOOP;\n"));
        this.wrappers.put(RefactorMenu.cmdWHILE, new Pair((Object)"WHILE condition LOOP\n", (Object)"END LOOP;\n"));
        this.wrappers.put(RefactorMenu.cmdBLOCK, new Pair((Object)"DECLARE\nBEGIN\n", (Object)"EXCEPTION\n   WHEN NO_DATA_FOUND THEN\nEND;\n"));
        this.wrappers.put(RefactorMenu.cmdIF, new Pair((Object)"IF condition THEN\n", (Object)"END IF;\n"));
    }

    public boolean surround(Context context, int n) {
        Node node = context.getNode();
        View view = context.getView();
        BasicEditorPane basicEditorPane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
        this.start = basicEditorPane.getSelectionStart();
        this.end = basicEditorPane.getSelectionEnd();
        if (this.end == 0 || this.start == this.end) {
            return false;
        }
        try {
            this.selection = basicEditorPane.getText(this.start, this.end - this.start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (!this.parse(this.selection)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("NotSequenceOfStatements"), null, null);
            return false;
        }
        String string = Surrounder.indentAt(this.start, basicEditorPane);
        basicEditorPane.setSelectionStart(this.start);
        basicEditorPane.setSelectionEnd(this.end);
        String string2 = this.ident(string, (String)this.wrappers.get((Object)Integer.valueOf((int)n)).first);
        Map map = CustomFormat.getInstance().options;
        Objects.requireNonNull(CustomFormat.getInstance());
        String string3 = this.ident(this.emptyStr((Integer)map.get("identSpaces")), this.selection);
        String string4 = this.ident(string, (String)this.wrappers.get((Object)Integer.valueOf((int)n)).second);
        basicEditorPane.replaceSelection(string2 + string3 + string4);
        return true;
    }

    private String emptyStr(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private String ident(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            Object object = stringTokenizer.nextToken();
            if (!"\n".equals(object)) {
                object = string + (String)object;
            }
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    private boolean parse(String string) {
        List list = LexerToken.parse((String)string);
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(list, matrix);
        return matrix.contains(0, list.size(), SqlEarley.getInstance().sql_statements);
    }

    static String indentAt(int n, BasicEditorPane basicEditorPane) {
        if (basicEditorPane == null) {
            return "";
        }
        int n2 = basicEditorPane.getLineFromOffset(n);
        int n3 = basicEditorPane.getLineStartOffset(n2);
        int n4 = basicEditorPane.getLineStartOffset(n2 + 1);
        String string = null;
        try {
            string = basicEditorPane.getText(n3, n4 - n3);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) {
                return stringBuffer.toString();
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }
}

