/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.Selection;

public class CaseConverter {
    public static CASE getState() {
        try {
            String string = DBConfig.getInstance().getString("CASECONVERTER_STATE");
            if (string == null || CASE.NONE.toString().equals(string) || "NONE".equals(string)) {
                return CASE.NONE;
            }
            if (CASE.UPPER.toString().equals(string) || "UPPER".equals(string)) {
                return CASE.UPPER;
            }
            if (CASE.LOWER.toString().equals(string) || "LOWER".equals(string)) {
                return CASE.LOWER;
            }
            if (CASE.INITCAP.toString().equals(string) || "INITCAP".equals(string)) {
                return CASE.INITCAP;
            }
            if (CASE.UPPER_KW.toString().equals(string) || "UPPER_KW".equals(string)) {
                return CASE.UPPER_KW;
            }
            if (CASE.LOWER_KW_UPPER_ID.toString().equals(string) || "LOWER_KW_UPPER_ID".equals(string)) {
                return CASE.LOWER_KW_UPPER_ID;
            }
            if (CASE.UPPER_KW_LOWER_ID.toString().equals(string) || "UPPER_KW_LOWER_ID".equals(string)) {
                return CASE.UPPER_KW_LOWER_ID;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return CASE.NONE;
    }

    public static boolean convert(Context context) {
        View view = context.getView();
        BasicEditorPane basicEditorPane = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
        return CaseConverter.convert(basicEditorPane);
    }

    public static boolean convert(BasicEditorPane basicEditorPane) {
        List list = basicEditorPane.getMultiSelections();
        int n = basicEditorPane.getSelectionStart();
        int n2 = basicEditorPane.getSelectionEnd();
        if (0 < list.size()) {
            CASE cASE = CaseConverter.getState().rotate();
            DBConfig.getInstance().putString("CASECONVERTER_STATE", cASE.toString());
            for (Selection selection : list) {
                int n3 = selection.getStart();
                int n4 = selection.getEnd();
                CaseConverter.convertFragment(basicEditorPane, cASE, n3, n4);
            }
            basicEditorPane.setMultiSelections((Collection)list);
            CaseConverter.convertFragment(basicEditorPane, cASE, n, n2);
            Ide.getStatusBar().setText(cASE.toString());
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(list);
            linkedList.add(new Selection(n2, n));
            basicEditorPane.setMultiSelections((Collection)linkedList);
            return true;
        }
        if (n2 == 0 || n == n2) {
            return false;
        }
        CASE cASE = CaseConverter.getState().rotate();
        DBConfig.getInstance().putString("CASECONVERTER_STATE", cASE.toString());
        try {
            String string = basicEditorPane.getText(n, n2 - n);
            String string2 = cASE.convert(string);
            for (int i = 0; i < 3; ++i) {
                if (!string2.equals(string)) continue;
                cASE = cASE.rotate();
                string2 = cASE.convert(string);
            }
            basicEditorPane.replaceSelection(string2);
            Ide.getStatusBar().setText(cASE.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        basicEditorPane.setSelectionStart(n);
        basicEditorPane.setSelectionEnd(n2);
        basicEditorPane.setToolTipText(cASE.toString());
        return true;
    }

    private static void convertFragment(BasicEditorPane basicEditorPane, CASE cASE, int n, int n2) {
        try {
            if (n == n2) {
                return;
            }
            String string = basicEditorPane.getText(n, n2 - n);
            String string2 = cASE.convert(string);
            basicEditorPane.setCaretPosition(n2);
            basicEditorPane.setSelectionStart(n);
            basicEditorPane.setSelectionEnd(n2);
            basicEditorPane.replaceSelection(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isKeyword(String string) {
        if (string == null) {
            return false;
        }
        return SqlEarley.getInstance().symbolIndexes.get("'" + string.toUpperCase() + "'") != null;
    }

    public static enum CASE {
        NONE{

            @Override
            public String convert(String string) {
                return string;
            }

            @Override
            CASE rotate() {
                return INITCAP;
            }

            public String toString() {
                return Messages.getString("CaseConverter.None");
            }
        }
        ,
        INITCAP{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    if (lexerToken.type == Token.IDENTIFIER || lexerToken.type == Token.DQUOTED_STRING) {
                        char[] cArray = new char[lexerToken.content.length()];
                        int n = 37;
                        for (int i = 0; i < cArray.length; ++i) {
                            char c = lexerToken.content.charAt(i);
                            cArray[i] = i == 0 || n == 95 || n == 34 ? Character.toUpperCase(c) : Character.toLowerCase(c);
                            n = c;
                        }
                        stringBuffer.append(cArray);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return UPPER;
            }

            public String toString() {
                return Messages.getString("CaseConverter.InitialCap");
            }
        }
        ,
        UPPER{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    if (lexerToken.type == Token.IDENTIFIER || lexerToken.type == Token.DQUOTED_STRING) {
                        String string2 = lexerToken.content.toUpperCase();
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return LOWER;
            }

            public String toString() {
                return Messages.getString("CaseConverter.UpperCase");
            }
        }
        ,
        UPPER_KW{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    String string2 = lexerToken.content;
                    if (lexerToken.type == Token.IDENTIFIER && CaseConverter.isKeyword(string2)) {
                        String string3 = string2.toUpperCase();
                        stringBuffer.append(string3);
                        continue;
                    }
                    stringBuffer.append(string2);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return LOWER_KW_UPPER_ID;
            }

            public String toString() {
                return Messages.getString("CaseConverter.UpperKeywords");
            }
        }
        ,
        LOWER{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    if (lexerToken.type == Token.IDENTIFIER || lexerToken.type == Token.DQUOTED_STRING) {
                        String string2 = lexerToken.content.toLowerCase();
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return UPPER_KW;
            }

            public String toString() {
                return Messages.getString("CaseConverter.LowerCase");
            }
        }
        ,
        LOWER_KW_UPPER_ID{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    String string2 = lexerToken.content;
                    if (lexerToken.type == Token.IDENTIFIER || lexerToken.type == Token.DQUOTED_STRING) {
                        if (CaseConverter.isKeyword(string2)) {
                            stringBuffer.append(string2.toLowerCase());
                            continue;
                        }
                        stringBuffer.append(string2.toUpperCase());
                        continue;
                    }
                    stringBuffer.append(string2);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return UPPER_KW_LOWER_ID;
            }

            public String toString() {
                return Messages.getString("CaseConverter.LowerKeywordsUpperIdentifiers");
            }
        }
        ,
        UPPER_KW_LOWER_ID{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    String string2 = lexerToken.content;
                    if (lexerToken.type == Token.IDENTIFIER || lexerToken.type == Token.DQUOTED_STRING) {
                        if (CaseConverter.isKeyword(string2)) {
                            stringBuffer.append(string2.toUpperCase());
                            continue;
                        }
                        stringBuffer.append(string2.toLowerCase());
                        continue;
                    }
                    stringBuffer.append(string2);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return INITCAP;
            }

            public String toString() {
                return Messages.getString("CaseConverter.UpperKeywordsLowerIdentifiers");
            }
        };


        public abstract String convert(String var1);

        abstract CASE rotate();
    }
}

