/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingClosure;
import oracle.sql.TIMESTAMP;

public class ExternalUpdateTracker
extends NodeListener
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(ExternalUpdateTracker.class.getName());
    private Map<String, TIMESTAMP> m_timestamps = new HashMap<String, TIMESTAMP>();
    private List<DatabaseSourceNode> m_changedNodes = new ArrayList<DatabaseSourceNode>();
    private Timer m_timer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExternalUpdateTracker.this.handleChangedNodes();
        }
    });

    private static TIMESTAMP getTimestamp(DatabaseSourceNode databaseSourceNode) {
        Object object = databaseSourceNode.getProperty("LAST_MODIFIED");
        return object instanceof TIMESTAMP ? (TIMESTAMP)object : null;
    }

    public ExternalUpdateTracker() {
        this.m_timer.setRepeats(false);
    }

    private TIMESTAMP getTimestamp(URL uRL) {
        String string = uRL.toExternalForm();
        return this.m_timestamps.get(string);
    }

    private void updateTimestamp(URL uRL, TIMESTAMP tIMESTAMP) {
        String string = uRL.toExternalForm();
        if (tIMESTAMP != null) {
            this.m_timestamps.put(string, tIMESTAMP);
        } else {
            this.m_timestamps.remove(string);
        }
    }

    private void clearTimestamp(DatabaseSourceNode databaseSourceNode) {
        URL uRL = databaseSourceNode.getURL();
        String string = uRL.toExternalForm();
        this.m_timestamps.remove(string);
    }

    public void nodeOpened(NodeEvent nodeEvent) {
        DatabaseSourceNode databaseSourceNode = (DatabaseSourceNode)nodeEvent.getNode();
        this.updateTimestamp(databaseSourceNode.getURL(), ExternalUpdateTracker.getTimestamp(databaseSourceNode));
        databaseSourceNode.attach(this);
    }

    public void nodeClosed(NodeEvent nodeEvent) {
        DatabaseSourceNode databaseSourceNode = (DatabaseSourceNode)nodeEvent.getNode();
        databaseSourceNode.detach(this);
        this.clearTimestamp(databaseSourceNode);
    }

    public void nodeSaved(NodeEvent nodeEvent) {
        super.nodeSaved(nodeEvent);
    }

    public void nodeReverted(NodeEvent nodeEvent) {
        super.nodeReverted(nodeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object object, UpdateMessage updateMessage) {
        DatabaseSourceNode databaseSourceNode;
        TIMESTAMP tIMESTAMP;
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.STRUCTURE_CHANGED && object instanceof DatabaseSourceNode && (tIMESTAMP = this.getTimestamp((databaseSourceNode = (DatabaseSourceNode)object).getURL())) != null) {
            TIMESTAMP tIMESTAMP2 = ExternalUpdateTracker.getTimestamp(databaseSourceNode);
            if (!tIMESTAMP.equals((Object)tIMESTAMP2)) {
                List<DatabaseSourceNode> list = this.m_changedNodes;
                synchronized (list) {
                    this.m_changedNodes.add(databaseSourceNode);
                }
            }
            this.m_timer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChangedNodes() {
        ArrayList<DatabaseSourceNode> arrayList = new ArrayList<DatabaseSourceNode>();
        List<DatabaseSourceNode> list = this.m_changedNodes;
        synchronized (list) {
            if (this.m_changedNodes.isEmpty()) {
                return;
            }
            arrayList.addAll(this.m_changedNodes);
            this.m_changedNodes.clear();
        }
        ExternalUpdateTracker.reloadBuffers(arrayList);
    }

    private static void reloadBuffers(Collection<DatabaseSourceNode> collection) {
        if (collection != null) {
            EnumSet<ReloadMode> enumSet = EnumSet.of(ReloadMode.RELOAD_PROMPTED_IF_DIRTY, ReloadMode.SILENT_RELOAD);
            ExternalUpdateTracker.reloadBuffers(collection, enumSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadBuffers(Collection<DatabaseSourceNode> collection, Set<ReloadMode> set) {
        ArrayList<DatabaseSourceNode> arrayList = new ArrayList<DatabaseSourceNode>();
        ArrayList<DatabaseSourceNode> arrayList2 = new ArrayList<DatabaseSourceNode>();
        int n = 0;
        PerformanceLogger.get().startTiming("NodeUtil.reloadBuffers");
        try {
            for (DatabaseSourceNode databaseSourceNode : collection) {
                if (databaseSourceNode == null || !databaseSourceNode.isOpen()) continue;
                ++n;
                LOGGER.fine("Checking open node: " + databaseSourceNode.getLongLabel());
                databaseSourceNode.isReadOnly();
                if (databaseSourceNode.getAttributes().isSet(ElementAttributes.NON_RELOADABLE)) continue;
                if (databaseSourceNode.isDirty() && set.contains((Object)ReloadMode.RELOAD_PROMPTED_IF_DIRTY) || !set.contains((Object)ReloadMode.SILENT_RELOAD)) {
                    arrayList2.add(databaseSourceNode);
                    continue;
                }
                arrayList.add(databaseSourceNode);
            }
            ExternalUpdateTracker.performReload(arrayList, arrayList2, set);
        }
        finally {
            PerformanceLogger.get().stopTiming("NodeUtil.reloadBuffers", "Checked " + n + " open nodes", 500);
        }
    }

    private static void performReload(final ArrayList<DatabaseSourceNode> arrayList, final ArrayList<DatabaseSourceNode> arrayList2, final Set<ReloadMode> set) {
        try {
            SwingClosure swingClosure = new SwingClosure(true){

                protected void runImpl() throws Exception {
                    if (arrayList2.size() == 0 && arrayList.size() == 0 && set.contains((Object)ReloadMode.INFORM_WHEN_NONE_NEED_RELOADING)) {
                        String string = IdeArb.getString((int)257);
                        String string2 = IdeArb.getString((int)258);
                        IdeMainWindow ideMainWindow = Ide.getMainWindow();
                        JOptionPane.showMessageDialog((Component)ideMainWindow, string2, string, 1);
                        return;
                    }
                    ArrayList<DatabaseSourceNode> arrayList3 = new ArrayList<DatabaseSourceNode>();
                    if (CommandProcessor.getInstance().isTransactionActive()) {
                        arrayList3.addAll(arrayList2);
                        arrayList2.clear();
                        arrayList3.addAll(arrayList);
                        arrayList.clear();
                    } else {
                        DatabaseSourceNode databaseSourceNode;
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            databaseSourceNode = (DatabaseSourceNode)iterator.next();
                            if (!databaseSourceNode.isReadOrWriteLockedOverride()) continue;
                            arrayList3.add(databaseSourceNode);
                            iterator.remove();
                        }
                        iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            databaseSourceNode = (DatabaseSourceNode)iterator.next();
                            if (!databaseSourceNode.isReadOrWriteLockedOverride()) continue;
                            arrayList3.add(databaseSourceNode);
                            iterator.remove();
                        }
                    }
                    ExternalUpdateTracker.autoReload(arrayList);
                    ExternalUpdateTracker.promptedReload(arrayList2);
                    ExternalUpdateTracker.problemReload(arrayList3);
                }
            };
            swingClosure.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void autoReload(ArrayList<DatabaseSourceNode> arrayList) {
        for (Node node : arrayList) {
            ExternalUpdateTracker.tryRevert(node);
        }
    }

    private static void promptedReload(ArrayList<DatabaseSourceNode> arrayList) {
        int n;
        String string;
        CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
        for (DatabaseSourceNode databaseSourceNode : arrayList) {
            Icon icon = databaseSourceNode.getIcon();
            string = URLFileSystem.getPlatformPathName((URL)databaseSourceNode.getURL());
            checkBoxListModel.addElement((Object)databaseSourceNode, icon, true, true, string);
        }
        int n2 = checkBoxListModel.getSize();
        if (n2 > 0 && (n = SelectFilesPanel.showDialog((String)IdeArb.getString((int)257), (String)IdeArb.format((int)218, (Object)checkBoxListModel.findTextForElement(0)), (String)IdeArb.getString((int)221), (CheckBoxListModel)checkBoxListModel, (boolean)true, (int)0, (String)"f1_idedexternallymodifiedfiles_html")) == 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                if (!checkBoxListModel.isElementSelected(i)) continue;
                string = (Node)checkBoxListModel.getUserObjectAt(i);
                ExternalUpdateTracker.tryRevert((Node)string);
            }
        }
    }

    private static void tryRevert(Node node) {
        try {
            node.revert();
        }
        catch (Exception exception) {
            LOGGER.severe(exception.getLocalizedMessage());
        }
    }

    private static void problemReload(ArrayList<DatabaseSourceNode> arrayList) {
        if (!arrayList.isEmpty()) {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            JComponent jComponent = ExternalUpdateTracker.createLabel(IdeArb.getString((int)489));
            JList jList = ExternalUpdateTracker.createList(arrayList, 8);
            JComponent jComponent2 = ExternalUpdateTracker.createLabel(IdeArb.getString((int)490));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.add((Component)jComponent, "North");
            jPanel.add((Component)new JScrollPane(jList), "Center");
            jPanel.add((Component)jComponent2, "South");
            String string = IdeArb.getString((int)491);
            String string2 = "f1_idedexternallymodifiedfilesproblem_html";
            MessageDialog.error((Component)ideMainWindow, (Object)jPanel, (String)string, (String)string2);
        }
    }

    private static JComponent createLabel(String string) {
        JTextArea jTextArea = new JTextArea(string, 0, 60);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setForeground(UIManager.getColor("Label.foreground"));
        jTextArea.setBackground(UIManager.getColor("Label.background"));
        return jTextArea;
    }

    private static JList createList(ArrayList<DatabaseSourceNode> arrayList, int n) {
        JList<Object> jList = new JList<Object>(arrayList.toArray());
        jList.setVisibleRowCount(n);
        jList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Node node = (Node)object;
                String string = node.getShortLabel() + " (" + URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)node.getURL())) + ")";
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        return jList;
    }

    private static enum ReloadMode {
        SILENT_RELOAD,
        RELOAD_PROMPTED_IF_DIRTY,
        INFORM_WHEN_NONE_NEED_RELOADING;

    }
}

