/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RecognizedRule;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.raptor.phighlight.Issue;
import oracle.dbtools.raptor.phighlight.SyntaxErrorTemplate;
import oracle.dbtools.util.Service;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.ItemTemplate;

public class SyntaxAdvice
extends Issue {
    int lineOffset;
    RecognizedRule[] problems;

    public static void main(String[] stringArray) throws IOException {
        String string = "select 1 from dual  select 2 from dual";
        string = Service.readFile(SyntaxAdvice.class, (String)"test.sql");
        List list = LexerToken.parse((String)string);
        SqlEarley sqlEarley = SqlEarley.partialRecognizer();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(list, matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"sql_statements", "subprg_body"}, (List)list, (Earley)SqlEarley.partialRecognizer(), (Matrix)matrix);
        if (syntaxError == null) {
            System.out.println("Syntax is correct");
            return;
        }
        System.out.println(syntaxError.toString());
        SyntaxAdvice syntaxAdvice = new SyntaxAdvice(10, 13, syntaxError);
        for (RecognizedRule recognizedRule : syntaxAdvice.problems) {
            System.out.println(recognizedRule);
        }
    }

    SyntaxAdvice(int n, int n2, SyntaxError syntaxError) {
        super(n, n2, "Not Used", Issue.Type.ERROR);
        this.lineOffset = syntaxError.offset;
        List list = syntaxError.topNrules(3, true);
        List<RecognizedRule> list2 = SyntaxAdvice.inline(list, syntaxError.matrix);
        List<RecognizedRule> list3 = SyntaxAdvice.inline(list2, syntaxError.matrix);
        List<RecognizedRule> list4 = SyntaxAdvice.inline(list3, syntaxError.matrix);
        List<RecognizedRule> list5 = SyntaxAdvice.inline(list4, syntaxError.matrix);
        RecognizedRule.merge((Collection)list, list2);
        RecognizedRule.merge((Collection)list, list3);
        RecognizedRule.merge((Collection)list, list4);
        RecognizedRule.merge((Collection)list, list5);
        LinkedList<RecognizedRule> linkedList = new LinkedList<RecognizedRule>();
        int n3 = 0;
        for (RecognizedRule recognizedRule : list) {
            if (recognizedRule.isRedundant(list) || !recognizedRule.isPresentable()) continue;
            linkedList.add(recognizedRule);
            if (5 >= ++n3) continue;
            break;
        }
        this.problems = linkedList.toArray(new RecognizedRule[0]);
    }

    @Override
    boolean isFixable() {
        return true;
    }

    @Override
    public ItemTemplate getItemTemplate(InfoTipHover infoTipHover, InfoTipStyles infoTipStyles, BasicEditorPane basicEditorPane, String string) {
        SyntaxErrorTemplate syntaxErrorTemplate = new SyntaxErrorTemplate(this.problems, infoTipStyles, basicEditorPane, this.from, this.to, this.lineOffset);
        return syntaxErrorTemplate;
    }

    private static List<RecognizedRule> inline(RecognizedRule recognizedRule, int n, Matrix matrix) {
        LinkedList<RecognizedRule> linkedList;
        block3: {
            Parser.Tuple[] tupleArray;
            int n2;
            block4: {
                linkedList = new LinkedList<RecognizedRule>();
                String string = recognizedRule.rhs[n];
                if ("...".equals(string)) {
                    return linkedList;
                }
                n2 = (Integer)SqlEarley.getInstance().symbolIndexes.get(string);
                Map map = HarvestDoc.getRailroads();
                DocURL docURL = (DocURL)map.get(n2);
                if (docURL != null || string.charAt(0) == '\'' || "identifier".equals(string)) break block3;
                tupleArray = SqlEarley.getInstance().rules;
                if (n >= recognizedRule.pos) break block4;
                Parser.EarleyCell earleyCell = matrix.get(recognizedRule.X, recognizedRule.Y);
                for (int i = 0; i < earleyCell.size(); ++i) {
                    int n3 = earleyCell.getRule(i);
                    int n4 = earleyCell.getPosition(i);
                    Parser.Tuple tuple = tupleArray[n3];
                    if (tuple.head != n2 || n4 != tuple.rhs.length) continue;
                    linkedList.add(new RecognizedRule(recognizedRule, n, tuple.rhs));
                }
                break block3;
            }
            if (n != recognizedRule.pos) break block3;
            for (int i = 0; i < tupleArray.length; ++i) {
                Parser.Tuple tuple = tupleArray[i];
                if (tuple.head != n2) continue;
                linkedList.add(new RecognizedRule(recognizedRule, n, tuple.rhs));
            }
        }
        return linkedList;
    }

    private static List<RecognizedRule> inline(List<RecognizedRule> list, Matrix matrix) {
        LinkedList<RecognizedRule> linkedList = new LinkedList<RecognizedRule>();
        LinkedList<RecognizedRule> linkedList2 = new LinkedList<RecognizedRule>();
        for (RecognizedRule recognizedRule : list) {
            for (int i = 0; i < recognizedRule.rhs.length; ++i) {
                List<RecognizedRule> list2 = SyntaxAdvice.inline(recognizedRule, i, matrix);
                if (0 < list2.size()) {
                    for (RecognizedRule recognizedRule2 : list) {
                        if (!recognizedRule2.head.equals(recognizedRule.rhs[i])) continue;
                        linkedList2.add(recognizedRule2);
                    }
                }
                for (RecognizedRule recognizedRule2 : list2) {
                    boolean bl = list.equals(recognizedRule2);
                    if (!bl) {
                        for (RecognizedRule recognizedRule3 : linkedList) {
                            if (!recognizedRule3.equals((Object)recognizedRule2)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (bl) continue;
                    linkedList.add(recognizedRule2);
                }
            }
        }
        linkedList.removeAll(linkedList2);
        return linkedList;
    }
}

