/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.RecognizedRule;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.phighlight.AdvisoryHoverBuilder;
import oracle.dbtools.raptor.phighlight.AsciiAdvice;
import oracle.dbtools.raptor.phighlight.EditorOverview;
import oracle.dbtools.raptor.phighlight.HighlightAddin;
import oracle.dbtools.raptor.phighlight.Issue;
import oracle.dbtools.raptor.phighlight.NuisanceLineNumsAdvice;
import oracle.dbtools.raptor.phighlight.SemanticAnalysis;
import oracle.dbtools.raptor.phighlight.SyntaxAdvice;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.keymap.IdeEditorPane;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.status.editor.StatusEditorPlugin;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewStatus;

public class HighlightEditorPlugin
implements EditorPlugin,
TooltipMessage,
ParserEventListener,
HoverProvider {
    private Logger logger = Logger.getLogger(HighlightEditorPlugin.class.getName());
    private BasicEditorPane _editorPane;
    private NodeListener _nodeListener;
    private HighlightLayer _highlightLayer;
    private Issue[] _errors;
    private String connection;
    private EditorOverview worksheetGUI;
    public static Map<BasicEditorPane, HighlightEditorPlugin> highlights = new HashMap<BasicEditorPane, HighlightEditorPlugin>();
    final String plsErrors = "audit-errors";
    final String plsWarnings = "audit-warnings";
    public static final String advisorErrorWarnings = "advisor-error-warnings";
    final String bookmarks = "Bookmark";
    private List<HighlightedText> wiggleHighlights = new LinkedList<HighlightedText>();
    private Set<Issue> wiggleRanges = new TreeSet<Issue>();
    private volatile Thread latestActiveAdvisor = null;

    public HighlightEditorPlugin() {
    }

    public HighlightEditorPlugin(BasicEditorPane basicEditorPane, String string, EditorOverview editorOverview) {
        this._editorPane = basicEditorPane;
        ((IdeEditorPane)this._editorPane).getMultiHoverProvider().registerProvider((HoverProvider)this);
        this.connection = string;
        this.worksheetGUI = editorOverview;
        highlights.put(basicEditorPane, this);
    }

    public BasicEditorPane getEditorPane() {
        return this._editorPane;
    }

    @Override
    public String getToolTipText(int n) {
        if (this._errors != null && 0 < this._errors.length) {
            for (int i = 0; i < this._errors.length; ++i) {
                Issue issue = this._errors[i];
                if (!issue.isInHighlight(n)) continue;
                String[] stringArray = issue.msg.split("\n");
                Object object = stringArray[0];
                if (stringArray.length > 1) {
                    object = (String)object + "...";
                }
                return object;
            }
        } else {
            for (Issue issue : this.wiggleRanges) {
                if (issue.from > n || n >= issue.to || issue.isFixable()) continue;
                return issue.msg;
            }
        }
        return null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._editorPane = basicEditorPane;
        final PlSqlNode plSqlNode = this.getNode();
        if (plSqlNode != null) {
            this._nodeListener = new NodeListener(){

                public void nodeSaved(NodeEvent nodeEvent) {
                    if (plSqlNode.getParser().text == null) {
                        return;
                    }
                    if (DBURLFormatHelper.isDBURL(plSqlNode.getURL())) {
                        HighlightEditorPlugin.this.updateHighlight();
                    }
                }
            };
            plSqlNode.addNodeListener(this._nodeListener);
            this.updateHighlight();
            plSqlNode.getParser().addParserEventListener(this);
        }
        ((IdeEditorPane)this._editorPane).getMultiHoverProvider().registerProvider((HoverProvider)this);
        this.deinstallStatusEditorPlugin();
        highlights.put(basicEditorPane, this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        PlSqlNode plSqlNode = this.getNode();
        plSqlNode.removeNodeListener(this._nodeListener);
        plSqlNode.getParser().removeParserEventListener(this);
        this._highlightLayer = null;
        this._editorPane = null;
        highlights.remove(basicEditorPane);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected PlSqlNode getNode() {
        Context context = (Context)this._editorPane.getProperty("editor-ide-context");
        PlSqlNode plSqlNode = null;
        if (context != null) {
            plSqlNode = (PlSqlNode)context.getNode();
        }
        return plSqlNode;
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null && this._editorPane != null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    private void deinstallStatusEditorPlugin() {
        try {
            Field field = BasicEditorPane.class.getDeclaredField("pluginList");
            field.setAccessible(true);
            ArrayList arrayList = (ArrayList)field.get(this._editorPane);
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                if (!(e instanceof StatusEditorPlugin)) continue;
                this._editorPane.deinstallPlugin((EditorPlugin)e);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public void updateHighlight() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object doInBackground() {
                HighlightEditorPlugin.this._errors = HighlightEditorPlugin.this.getErrors();
                return null;
            }

            @Override
            public void done() {
                HighlightLayer highlightLayer = HighlightEditorPlugin.this.getHighlightLayer();
                if (highlightLayer == null) {
                    return;
                }
                highlightLayer.removeAllHighlights();
                HighlightStyle highlightStyle = HighlightAddin.getErrorHighlightStyle();
                HighlightStyle highlightStyle2 = HighlightAddin.getWarningHighlightStyle();
                CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)HighlightEditorPlugin.this._editorPane);
                BasicEditorOverview basicEditorOverview = codeEditor.getOverview();
                basicEditorOverview.removeMarks((Object)"audit-errors");
                basicEditorOverview.removeMarks((Object)"audit-warnings");
                basicEditorOverview.removeMarks((Object)HighlightEditorPlugin.advisorErrorWarnings);
                int n = HighlightEditorPlugin.this._editorPane.getLineCount();
                if (n == 0) {
                    return;
                }
                for (int i = 0; i < HighlightEditorPlugin.this._errors.length; ++i) {
                    Color color;
                    HighlightStyle highlightStyle3;
                    String string;
                    Issue issue = HighlightEditorPlugin.this._errors[i];
                    int n2 = issue.line;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 >= n) {
                        n2 = n - 1;
                    }
                    String string2 = issue.msg;
                    if (issue.isError()) {
                        string = "audit-errors";
                        highlightStyle3 = highlightStyle;
                        color = OverviewStatus.ERROR;
                    } else {
                        string = "audit-warnings";
                        highlightStyle3 = highlightStyle2;
                        color = OverviewStatus.WARNING;
                    }
                    try {
                        int n3;
                        int n4;
                        int n5 = HighlightEditorPlugin.this._editorPane.getLineCount();
                        if (n5 < n2) {
                            HighlightEditorPlugin.this.logger.log(Level.SEVERE, "Could not highlight: #lines = " + n5 + ", line=" + n2);
                            return;
                        }
                        int n6 = HighlightEditorPlugin.this._editorPane.getLineStartOffset(n2);
                        int n7 = HighlightEditorPlugin.this._editorPane.getLineEndOffset(n2);
                        if (string2.startsWith("PLS-00103:")) {
                            n4 = issue.offset;
                            n3 = n6 + n4;
                            n2 = HighlightEditorPlugin.this._editorPane.getLineFromOffset(n3);
                            highlightLayer.addHighlight(highlightStyle3, n3, n3 + 1);
                            issue.setHighlights(n3, n3);
                            basicEditorOverview.addMark((OverviewMark)new BasicEditorOverviewMark(HighlightEditorPlugin.this._editorPane, Integer.valueOf(n3), Integer.valueOf(n3), 2.0f, color), (Object)string);
                            continue;
                        }
                        n4 = n6 + issue.offset;
                        n3 = n7 - 1;
                        highlightLayer.addHighlight(highlightStyle3, n4, n3);
                        issue.setHighlights(n4, n3);
                        basicEditorOverview.addMark((OverviewMark)new BasicEditorOverviewMark(HighlightEditorPlugin.this._editorPane, Integer.valueOf(n4), Integer.valueOf(n4), 2.0f, color), (Object)string);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                OverviewStatus overviewStatus = basicEditorOverview.getStatus();
                if (overviewStatus != null) {
                    if (0 < HighlightEditorPlugin.this._errors.length) {
                        overviewStatus.setColor(OverviewStatus.ERROR);
                    } else {
                        overviewStatus.setColor(OverviewStatus.OK);
                    }
                }
                HighlightEditorPlugin.this.renderAdvisorHighlights(null);
            }
        };
        swingWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Issue[] getErrors() {
        ResultSet resultSet;
        String string;
        ArrayList<Issue> arrayList;
        block20: {
            Issue[] issueArray;
            block19: {
                Issue[] issueArray2;
                block18: {
                    arrayList = new ArrayList<Issue>();
                    PlSqlNode plSqlNode = this.getNode();
                    URL uRL = plSqlNode.getURL();
                    String string2 = DBURLFormatHelper.getBaseType(uRL);
                    if (string2 == null) {
                        return new Issue[0];
                    }
                    string = plSqlNode.getConnectionName();
                    if (string == null) {
                        return new Issue[0];
                    }
                    resultSet = null;
                    try {
                        boolean bl;
                        Connection connection = Connections.getInstance().getConnection(string);
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        arrayList2.add(string2);
                        arrayList2.add(plSqlNode.getSrcName());
                        if (!Connections.getInstance().lock(string)) {
                            Issue[] issueArray3 = new Issue[]{};
                            return issueArray3;
                        }
                        resultSet = DBUtil.getInstance((String)string).executeQuery(this.getErrorReportQuery(connection), arrayList2);
                        if (resultSet == null) {
                            issueArray2 = new Issue[]{};
                            Connections.getInstance().unlock(string);
                            break block18;
                        }
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        boolean bl2 = bl = resultSetMetaData.getColumnCount() == 4;
                        while (resultSet.next()) {
                            if (plSqlNode.getParser().text == null) {
                                issueArray = new Issue[]{};
                                Connections.getInstance().unlock(string);
                                break block19;
                            }
                            int n = resultSet.getInt(1);
                            if (n == 0) {
                                n = 1;
                            }
                            int n2 = n - 1 + plSqlNode.offset(string2);
                            int n3 = resultSet.getInt(2);
                            if (n3 == 0) {
                                n3 = 1;
                            }
                            int n4 = n3 - 1;
                            String string3 = resultSet.getString(3);
                            boolean bl3 = bl ? "ERROR".equals(resultSet.getString(4)) : true;
                            Issue issue = new Issue(n2, n4, string3, bl3);
                            arrayList.add(issue);
                        }
                        Connections.getInstance().unlock(string);
                        break block20;
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        return arrayList.toArray(new Issue[arrayList.size()]);
                    }
                    catch (DBException dBException) {
                        return arrayList.toArray(new Issue[arrayList.size()]);
                    }
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
                return issueArray2;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            return issueArray;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        return arrayList.toArray(new Issue[arrayList.size()]);
        finally {
            Connections.getInstance().unlock(string);
            DBUtil.closeResultSet(resultSet);
        }
    }

    private String getErrorReportQuery(Connection connection) throws SQLException {
        if (connection.getMetaData().getDatabaseMajorVersion() > 9) {
            return "SELECT LINE,POSITION,TEXT,ATTRIBUTE FROM USER_ERRORS WHERE TYPE=? AND NAME=? ";
        }
        return "SELECT LINE,POSITION,TEXT FROM USER_ERRORS WHERE TYPE=? AND NAME=? ";
    }

    public void setWiggleRanges(List<Issue> list) {
        this.wiggleRanges = new TreeSet<Issue>();
        this.wiggleRanges.addAll(list);
    }

    @Override
    public void stateChanged(final BackgroundParser backgroundParser) {
        int n;
        int n2;
        int n3;
        List<LexerToken> list = backgroundParser.src;
        if (list == null) {
            return;
        }
        if (200000 <= list.size()) {
            return;
        }
        final int n4 = this._editorPane.getCaretPosition();
        int n5 = LexerToken.scanner2parserOffset(list, (int)n4);
        this.wiggleRanges = new TreeSet<Issue>();
        LazyNode lazyNode = backgroundParser.output;
        String string = HighlightEditorPlugin.verifyPadding(backgroundParser.text, "\n  ");
        if (string == null) {
            string = HighlightEditorPlugin.verifyPadding(backgroundParser.text, "\n\r  ");
        }
        if (string == null) {
            string = HighlightEditorPlugin.verifyPadding(backgroundParser.text, "\n ");
        }
        if (string == null) {
            string = HighlightEditorPlugin.verifyPadding(backgroundParser.text, "\n\r ");
        }
        if (string == null) {
            string = HighlightEditorPlugin.verifyPadding(backgroundParser.text, "\n");
        }
        if (string == null) {
            string = HighlightEditorPlugin.verifyPadding(backgroundParser.text, "\n\r");
        }
        if (string != null) {
            n3 = backgroundParser.text.indexOf(string + "2");
            n2 = backgroundParser.text.indexOf(string + "3");
            if (0 < n3 && 0 < n2) {
                this.wiggleRanges.add(new NuisanceLineNumsAdvice(n3 + string.length(), string));
            }
            lazyNode = null;
        }
        n3 = 0;
        if (backgroundParser.src != null) {
            block0: for (LexerToken lexerToken : backgroundParser.src) {
                if (lexerToken.type == Token.DQUOTED_STRING || lexerToken.type == Token.QUOTED_STRING || lexerToken.type == Token.COMMENT || lexerToken.type == Token.LINE_COMMENT) continue;
                for (n = 0; n < lexerToken.content.length(); ++n) {
                    char c = lexerToken.content.charAt(n);
                    int n6 = lexerToken.begin + n;
                    if (c >= '\u0590' && c <= '\u06ff') {
                        lazyNode = null;
                        continue block0;
                    }
                    if (c != '\u201c' && c != '\u201d' && c != '\u2018' && c != '\u2019') continue;
                    this.wiggleRanges.add(new AsciiAdvice(n6, c));
                    if (100 < n3++) continue block0;
                }
            }
        } else {
            for (n2 = 0; backgroundParser.text != null && n2 < backgroundParser.text.length(); ++n2) {
                char c = backgroundParser.text.charAt(n2);
                if (c >= '\u0590' && c <= '\u06ff') {
                    lazyNode = null;
                } else {
                    if (c != '\u201c' && c != '\u201d' && c != '\u2018' && c != '\u2019') continue;
                    this.wiggleRanges.add(new AsciiAdvice(n2, c));
                    if (100 >= n3++) {
                        continue;
                    }
                }
                break;
            }
        }
        if (lazyNode != null) {
            Object var8_10 = null;
            SyntaxError syntaxError = SyntaxError.checkSyntax((String)backgroundParser.text, (String[])new String[]{"sql_statements", "subprg_body", "select", "insert", "update", "delete", "merge"}, backgroundParser.src, (Earley)SqlEarley.partialRecognizer(), (Matrix)backgroundParser.matrix);
            if (syntaxError != null) {
                n = 0;
                for (RecognizedRule recognizedRule : syntaxError.topNrules(10, true)) {
                    if (!recognizedRule.toString().startsWith("unlabeled_nonblock_stmt: sql_stmt")) continue;
                    n = 1;
                }
                int n7 = backgroundParser.matrix.lastY();
                if (n7 < backgroundParser.src.size()) {
                    n = 0;
                }
                if (n == 0) {
                    this.markErrors(syntaxError, backgroundParser, 0);
                }
            }
            if ((var8_10 != null && var8_10.isDML(null) || var8_10 == null) && list.size() <= 20000 && DBConfig.getInstance().getBoolean("SEMANTICANALYSISINFOTIP").booleanValue()) {
                PlSqlNode plSqlNode = this.getNode();
                if (plSqlNode != null) {
                    this.connection = plSqlNode.getConnectionName();
                }
                new Thread(){

                    @Override
                    public void run() {
                        DBConfig dBConfig = DBConfig.getInstance();
                        try {
                            Thread.sleep(dBConfig.getInt("DELAYCOMPLETION") + 100);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (HighlightEditorPlugin.this.latestActiveAdvisor != null) {
                            return;
                        }
                        HighlightEditorPlugin.this.latestActiveAdvisor = this;
                        SemanticAnalysis.doIt(backgroundParser.src, backgroundParser.text, backgroundParser.root, 0, n4, HighlightEditorPlugin.this.wiggleRanges, HighlightEditorPlugin.this.connection);
                        HighlightEditorPlugin.this.latestActiveAdvisor = null;
                        HighlightEditorPlugin.this.renderAdvisorHighlights(backgroundParser);
                    }
                }.start();
            }
        }
        this.renderAdvisorHighlights(backgroundParser);
    }

    public void renderAdvisorHighlights(BackgroundParser backgroundParser) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public synchronized void run() {
                OverviewStatus overviewStatus;
                if (HighlightEditorPlugin.this._errors != null && 0 < HighlightEditorPlugin.this._errors.length) {
                    return;
                }
                HighlightLayer highlightLayer = HighlightEditorPlugin.this.getHighlightLayer();
                if (highlightLayer == null) {
                    return;
                }
                CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)HighlightEditorPlugin.this._editorPane);
                BasicEditorOverview basicEditorOverview = null;
                if (codeEditor != null) {
                    basicEditorOverview = codeEditor.getOverview();
                }
                if (HighlightEditorPlugin.this.worksheetGUI != null) {
                    basicEditorOverview = HighlightEditorPlugin.this.worksheetGUI.getEditorOverview();
                }
                if (basicEditorOverview != null) {
                    basicEditorOverview.removeMarks((Object)HighlightEditorPlugin.advisorErrorWarnings);
                }
                for (HighlightedText object2 : HighlightEditorPlugin.this.wiggleHighlights) {
                    highlightLayer.removeHighlight(object2);
                }
                Object object3 = OverviewStatus.OK;
                for (Issue issue : HighlightEditorPlugin.this.wiggleRanges) {
                    HighlightEditorPlugin.this.wiggleHighlights.add(highlightLayer.addHighlight(issue.getHighlightStyle(), issue.from, issue.to));
                    Color color = Color.ORANGE;
                    if (issue.isError()) {
                        color = Color.MAGENTA;
                    }
                    if (object3 != Color.MAGENTA) {
                        object3 = color;
                    }
                    if (basicEditorOverview == null) continue;
                    basicEditorOverview.addMark((OverviewMark)new BasicEditorOverviewMark(HighlightEditorPlugin.this._editorPane, Integer.valueOf(issue.from), Integer.valueOf(issue.from), 2.0f, color), (Object)HighlightEditorPlugin.advisorErrorWarnings);
                }
                if (basicEditorOverview != null && 0 < HighlightEditorPlugin.this.wiggleRanges.size() && (overviewStatus = basicEditorOverview.getStatus()) != null) {
                    overviewStatus.setColor((Color)object3);
                }
            }
        });
    }

    private static String verifyPadding(String string, String string2) {
        int n = string.indexOf(string2 + "2");
        if (0 < n) {
            return string2;
        }
        return null;
    }

    private void markErrors(SyntaxError syntaxError, BackgroundParser backgroundParser, int n) {
        n += syntaxError.end;
        int n2 = 3;
        if (syntaxError.getSuggestions().length == 1 && syntaxError.getSuggestions()[0].charAt(0) == '\'') {
            n2 = syntaxError.getSuggestions()[0].length();
        }
        int n3 = n + n2;
        if (backgroundParser.text.length() < n3) {
            n3 = backgroundParser.text.length();
        }
        for (LexerToken lexerToken : backgroundParser.src) {
            if (lexerToken.end <= n) continue;
            n = lexerToken.begin;
            n3 = lexerToken.end;
            break;
        }
        if (0 < n && n3 < n + 3) {
            --n;
        }
        this.wiggleRanges.add(new SyntaxAdvice(n, n3, syntaxError));
    }

    public Hover hover(JComponent jComponent, Point point, List<HoverFlavor> list) {
        AdvisoryHoverBuilder advisoryHoverBuilder = new AdvisoryHoverBuilder(jComponent, point, list, this._editorPane, this.wiggleRanges, InfoTipStyles.CODE);
        Hover hover = advisoryHoverBuilder.getHover();
        if (hover != null) {
            hover.showHover();
        }
        return hover;
    }
}

