/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.recent;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Service;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

class Tracker
extends NodeListener
implements Subject,
Observer,
IObjectActionListener,
ConnectionListener {
    static final int URL_ADDED_MESSAGE = UpdateMessage.newMessageID((String)"URLAdded");
    static final int URL_REMOVED_MESSAGE = UpdateMessage.newMessageID((String)"URLRemoved");
    static final int URL_CHANGED_MESSAGE = UpdateMessage.newMessageID((String)"URLChanged");
    private Subject m_delegate;
    private Set<URL> m_recentURLs = new HashSet<URL>();

    Tracker() {
        Node.addNodeListenerForType(ViewerNode.class, (NodeListener)this);
        Node.addNodeListenerForType(PlSqlNode.class, (NodeListener)this);
        Connections.getInstance().addConnectionListener(this);
        ObjectActionController.addListener(this);
    }

    public void nodeWillOpen(NodeEvent nodeEvent) {
        nodeEvent.getNode().attach((Observer)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Observer observer) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.m_delegate == null) {
                this.m_delegate = new IdeSubject();
            }
            this.m_delegate.attach(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Observer observer) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.m_delegate != null) {
                this.m_delegate.detach(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.m_delegate != null) {
                this.m_delegate.notifyObservers(object, updateMessage);
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.OBJECT_OPENED) {
            if (object instanceof PlSqlNode && ((PlSqlNode)object).getProperty("OBJECT_ID") != null) {
                this.addURL(((PlSqlNode)object).getURL());
            }
        } else if (n == ViewerNode.RELATION_NODE_CHANGED_MESSAGE_ID) {
            DBObject dBObject = ((ViewerNode)object).getDBObject();
            this.addURL(dBObject.getURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addURL(URL uRL) {
        if (DBURLFormatHelper.isDBURL(uRL)) {
            Tracker tracker = this;
            synchronized (tracker) {
                this.m_recentURLs.add(uRL);
                UpdateMessage updateMessage = new UpdateMessage(URL_ADDED_MESSAGE, (Object)this);
                updateMessage.getAddObjects().add(uRL);
                this.notifyObservers(this, updateMessage);
            }
        }
    }

    public Collection<URL> getRecentURLs() {
        return new ArrayList<URL>(this.m_recentURLs);
    }

    @Override
    public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
    }

    @Override
    public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        if (objectAction.isRenameAction()) {
            URL uRL = dBObject.getURL();
            Tracker tracker = this;
            synchronized (tracker) {
                if (this.m_recentURLs.contains(uRL)) {
                    if (list.size() > 0) {
                        String string2 = list.get(list.size() - 1);
                        URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", dBObject.getConnectionName(), dBObject.getCatalog(), dBObject.getSchemaName(), dBObject.getObjectType()), Service.handleMixedCase((String)string2));
                        UpdateMessage updateMessage = new UpdateMessage(URL_CHANGED_MESSAGE, (Object)this);
                        updateMessage.getModifyObjects().add(new Pair((Object)uRL, (Object)uRL2));
                        this.notifyObservers(this, updateMessage);
                    } else {
                        UpdateMessage updateMessage = new UpdateMessage(URL_REMOVED_MESSAGE, (Object)this);
                        updateMessage.getRemoveObjects().add(uRL);
                        this.notifyObservers(this, updateMessage);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        URL uRL = dBObject.getURL();
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.m_recentURLs.remove(uRL)) {
                UpdateMessage updateMessage = new UpdateMessage(URL_REMOVED_MESSAGE, (Object)this);
                updateMessage.getRemoveObjects().add(uRL);
                this.notifyObservers(this, updateMessage);
            }
        }
    }

    @Override
    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionModified(ConnectionEvent connectionEvent) {
        this.processConnectionModification(connectionEvent);
    }

    @Override
    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    @Override
    public void connectionRemoved(ConnectionEvent connectionEvent) {
        this.processConnectionModification(connectionEvent);
    }

    @Override
    public void connectionRenamed(ConnectionEvent connectionEvent) {
        this.processConnectionModification(connectionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnectionModification(ConnectionEvent connectionEvent) {
        ArrayList<URL> arrayList = null;
        String string = connectionEvent.getConnectionName();
        Tracker tracker = this;
        synchronized (tracker) {
            for (URL uRL : this.m_recentURLs) {
                String string2 = DBURLFormatHelper.getConnectionName(uRL);
                if (!ModelUtil.areEqual((Object)string, (Object)string2)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<URL>();
                }
                arrayList.add(uRL);
            }
            if (arrayList != null) {
                UpdateMessage updateMessage = new UpdateMessage(URL_REMOVED_MESSAGE, (Object)this);
                updateMessage.getRemoveObjects().addAll(arrayList);
            }
        }
    }
}

