/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.jsoneditor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.http.JsonParserHandler;
import oracle.dbtools.raptor.cloud.navigator.ViewerStyle;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;

public class RowDataHandler {
    public static JsonParserHandler<List<Row>> getHandler() {
        return RowDataHandler.getHandler(ViewerStyle.TABLE);
    }

    public static JsonParserHandler<List<Row>> getHandler(final ViewerStyle viewerStyle) {
        return new JsonParserHandler<List<Row>>(){

            /*
             * Enabled aggressive block sorting
             */
            private List<Row> getVerticalRowsFromArray(JsonParser jsonParser) throws IOException {
                ArrayList<Row> arrayList = new ArrayList<Row>();
                JsonToken jsonToken = jsonParser.nextToken();
                int n = 0;
                while (jsonToken != null) {
                    ArrayList<Column> arrayList2 = new ArrayList<Column>();
                    switch (jsonToken) {
                        case FIELD_NAME: {
                            Pair<String, Object> pair = this.getJSONValue(jsonParser, jsonToken);
                            arrayList2.add(new Column("Name", n, pair.first()));
                            arrayList2.add(new Column("Value", n, pair.second()));
                            ++n;
                            arrayList.add(new Row(arrayList2));
                            break;
                        }
                        case END_OBJECT: {
                            return arrayList;
                        }
                    }
                    jsonToken = jsonParser.nextToken();
                }
                return arrayList;
            }

            private Row getRowFromArray(JsonParser jsonParser) throws IOException {
                ArrayList<Column> arrayList = new ArrayList<Column>();
                JsonToken jsonToken = jsonParser.nextToken();
                int n = 0;
                block4: while (jsonToken != null) {
                    switch (jsonToken) {
                        case FIELD_NAME: {
                            Pair<String, Object> pair = this.getJSONValue(jsonParser, jsonToken);
                            arrayList.add(new Column((String)pair.first(), n, pair.second()));
                            break;
                        }
                        case END_OBJECT: {
                            break block4;
                        }
                        default: {
                            Logger.warn(RowDataHandler.class, (String)("json:Expected a property but got: " + jsonToken));
                        }
                    }
                    jsonToken = jsonParser.nextToken();
                }
                return new Row(arrayList);
            }

            private Pair<String, Object> getJSONValue(JsonParser jsonParser, JsonToken jsonToken) throws IOException {
                Object object = null;
                String string = jsonParser.getCurrentName();
                jsonToken = jsonParser.nextToken();
                switch (jsonToken) {
                    case VALUE_TRUE: {
                        object = Boolean.TRUE;
                        break;
                    }
                    case VALUE_FALSE: {
                        object = Boolean.FALSE;
                        break;
                    }
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: {
                        object = jsonParser.getNumberValue();
                        break;
                    }
                    case VALUE_STRING: {
                        object = jsonParser.getText();
                        break;
                    }
                }
                return Pair.pair((Object)string, (Object)object);
            }

            protected List<Row> build(JsonParser jsonParser) throws IOException {
                ArrayList<Row> arrayList = new ArrayList<Row>();
                boolean bl = true;
                JsonToken jsonToken = jsonParser.nextToken();
                block11: while (jsonToken != null) {
                    block0 : switch (jsonToken) {
                        case START_OBJECT: {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            throw new IOException(new IllegalStateException("Invalid JSON document"));
                        }
                        case FIELD_NAME: {
                            if (!"items".equals(jsonParser.getCurrentName())) break;
                            block12: while (!jsonParser.isClosed()) {
                                jsonToken = jsonParser.nextToken();
                                switch (jsonToken) {
                                    case START_ARRAY: {
                                        continue block12;
                                    }
                                    case START_OBJECT: {
                                        if (viewerStyle == ViewerStyle.VTABLE) {
                                            for (Row row : this.getVerticalRowsFromArray(jsonParser)) {
                                                arrayList.add(row);
                                            }
                                            continue block12;
                                        }
                                        arrayList.add(this.getRowFromArray(jsonParser));
                                        continue block12;
                                    }
                                    case FIELD_NAME: {
                                        Pair<String, Object> pair = this.getJSONValue(jsonParser, jsonToken);
                                        continue block12;
                                    }
                                    case END_ARRAY: {
                                        break block0;
                                    }
                                }
                                Logger.warn(RowDataHandler.class, (String)("json:Expected a property but got: " + jsonToken));
                            }
                            break;
                        }
                        case END_OBJECT: {
                            break block11;
                        }
                        default: {
                            Logger.warn(RowDataHandler.class, (String)("json:Expected a property but got: " + jsonToken));
                        }
                    }
                    jsonToken = jsonParser.nextToken();
                }
                return arrayList;
            }
        };
    }

    public static class Column {
        final String _name;
        final int _seq;
        final Object _value;

        public Column(String string, int n, Object object) {
            this._name = string;
            this._seq = n;
            this._value = object;
        }

        public String getName() {
            return this._name;
        }
    }

    public static class Row {
        final List<Column> _cols;

        public Row(List<Column> list) {
            this._cols = list;
        }

        public int getColCount() {
            return this._cols.size();
        }

        public List<Column> getColumns() {
            return this._cols;
        }

        public Object[] getData() {
            Object[] objectArray = new Object[this._cols.size()];
            for (int i = 0; i < this._cols.size(); ++i) {
                objectArray[i] = this._cols.get((int)i)._value;
            }
            return objectArray;
        }

        public Vector getData(List<String> list) {
            Vector<Object> vector = new Vector<Object>();
            for (String string : list) {
                boolean bl = false;
                for (Column column : this._cols) {
                    if (!column.getName().equals(string)) continue;
                    vector.add(column._value);
                    bl = true;
                }
                if (bl) continue;
                vector.add("");
            }
            return vector;
        }
    }
}

