/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.raptor.navigator.ColoredDisplayable;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.model.Attributes;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.resource.ExplorerArb;
import oracle.javatools.ui.Fonts;
import oracle.javatools.ui.themes.Themes;

final class CustomTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Color inactiveBackgroundSelectionColor;
    private Color inactiveTextSelectionColor;
    private Attributes _attributes;
    private Map<Integer, Font> fonts = new HashMap<Integer, Font>(4);
    private boolean treeHasFocus;
    private static final Integer PLAIN_STYLE = 0;
    private static final Integer ITALIC_STYLE = 2;

    public CustomTreeCellRenderer() {
        this.inactiveBackgroundSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
        if (this.inactiveBackgroundSelectionColor == null) {
            this.inactiveBackgroundSelectionColor = this.backgroundSelectionColor;
        }
        this.inactiveTextSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground");
        if (this.inactiveTextSelectionColor == null) {
            this.inactiveTextSelectionColor = this.textSelectionColor;
        }
    }

    @Override
    public Color getBackgroundNonSelectionColor() {
        if (Themes.isThemed()) {
            return null;
        }
        return super.getBackgroundNonSelectionColor();
    }

    @Override
    public Color getBackground() {
        if (Themes.isThemed()) {
            return null;
        }
        return super.getBackground();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.treeHasFocus = jTree.hasFocus();
        NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)object;
        Displayable displayable = CustomTreeCellRenderer.getDisplayable(navigatorTreeNode);
        this.setEnabled(jTree.isEnabled());
        this.setFont(this.getFont(jTree, navigatorTreeNode));
        if (displayable != null) {
            Color color;
            Icon icon = displayable.getIcon();
            if (icon == null) {
                icon = ExplorerArb.getIcon((int)6);
            }
            this.setIcon(icon);
            String string = this.getShortLabel(displayable, navigatorTreeNode);
            this.setText(string);
            String string2 = displayable.getToolTipText();
            if (string2 != null) {
                this.setToolTipText(string2);
            }
            if (displayable instanceof ColoredDisplayable && (color = ((ColoredDisplayable)displayable).getColor()) != null) {
                this.setForeground(color);
            }
        }
        return this;
    }

    @Override
    public Icon getDisabledIcon() {
        Icon icon = super.getDisabledIcon();
        if (icon == null) {
            Icon icon2 = super.getIcon();
            if (icon2 instanceof ImageIcon) {
                Image image = GrayFilter.createDisabledImage(((ImageIcon)icon2).getImage());
                return new ImageIcon(image);
            }
            if (icon2 instanceof OverlayIcon) {
                return CustomTreeCellRenderer.createDisabledIcon((OverlayIcon)icon2);
            }
            return icon2;
        }
        return icon;
    }

    @Override
    public Color getBackgroundSelectionColor() {
        return this.treeHasFocus ? super.getBackgroundSelectionColor() : this.inactiveBackgroundSelectionColor;
    }

    @Override
    public Color getTextSelectionColor() {
        return this.treeHasFocus ? super.getTextSelectionColor() : this.inactiveTextSelectionColor;
    }

    private String getShortLabel(Displayable displayable, NavigatorTreeNode navigatorTreeNode) {
        Element element;
        String string = displayable.getShortLabel();
        if (string == null) {
            string = "<null>";
        } else if (this.getAttributes().isSet(CellRendererAttributes.HIDE_FILE_EXTENSIONS) && (element = navigatorTreeNode.getElement()).getAttributes().isSet(ElementAttributes.HIDE_FILE_EXTENSION)) {
            int n = string.lastIndexOf(46);
            string = n > 0 ? string.substring(0, n) : string;
        }
        return string;
    }

    protected void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    protected Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new CellRendererAttributes();
        }
        return this._attributes;
    }

    private static Displayable getDisplayable(NavigatorTreeNode navigatorTreeNode) {
        return navigatorTreeNode;
    }

    private static Icon createDisabledIcon(OverlayIcon overlayIcon) {
        Collection collection = overlayIcon.getIcons();
        ArrayList<Icon> arrayList = new ArrayList<Icon>(collection.size());
        for (Icon icon : collection) {
            if (icon != null && icon instanceof ImageIcon) {
                icon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
            }
            arrayList.add(icon);
        }
        return new OverlayIcon(arrayList);
    }

    private boolean isDirty(NavigatorTreeNode navigatorTreeNode) {
        Element element = navigatorTreeNode.getElement();
        if (element == null) {
            return false;
        }
        Attributes attributes = element.getAttributes();
        if (this.getAttributes().isSet(CellRendererAttributes.HIDE_FILE_EXTENSIONS) && attributes.isSet(ElementAttributes.COMPOSITE)) {
            return attributes.isSet(ElementAttributes.DIRTY_COMPOSITE);
        }
        return attributes.isSet(ElementAttributes.DIRTY);
    }

    private Integer getFontStyle(JTree jTree, NavigatorTreeNode navigatorTreeNode) {
        boolean bl = this.isDirty(navigatorTreeNode);
        return bl ? ITALIC_STYLE : PLAIN_STYLE;
    }

    private Font getFont(JTree jTree, NavigatorTreeNode navigatorTreeNode) {
        Integer n = this.getFontStyle(jTree, navigatorTreeNode);
        Font font = this.fonts.get(n);
        if (!(font instanceof Font)) {
            font = UIManager.getFont("Oracle.dirtyFont");
            if (font == null || (n & 2) != 2) {
                font = jTree.getFont();
            }
            font = Fonts.deriveFont((Font)font, (int)n, (float)font.getSize2D());
            this.fonts.put(n, font);
        }
        return font;
    }
}

