/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.compiler.OraSubmitResults;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.plsql.OraPls;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Node;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public final class PlSqlTranslator {
    private PlSqlNode m_node;
    private List<PlSqlErrorInfo> m_results;

    public PlSqlTranslator(PlSqlNode plSqlNode) {
        this.m_node = plSqlNode;
    }

    public boolean translate() {
        this.m_results = new ArrayList<PlSqlErrorInfo>();
        try {
            String string = this.m_node.getConnectionName();
            Connection connection = Connections.getInstance().getConnection(string, true);
            if (connection == null) {
                PlSqlErrorInfo plSqlErrorInfo = new PlSqlErrorInfo(-1, -1, DatabaseNavigatorResources.format("PLSQL_TRANSLATOR_MISSING_CONNECTION", string));
                this.m_results.add(plSqlErrorInfo);
                return false;
            }
            OraPls oraPls = new OraPls(connection);
            String string2 = this.m_node.getSrcOwner();
            if (string2 == null) {
                string2 = this.m_node.getOwner();
            }
            String string3 = this.m_node.getSource();
            OraSubmitResults oraSubmitResults = oraPls.plsSubmit(string2, string3);
            List list = oraSubmitResults.getErrorList();
            this.m_results.addAll(list);
            if (null != list) {
                // empty if block
            }
            if (!oraSubmitResults.isSubmitFailed()) {
                this.m_node.markDirty(false);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            PlSqlErrorInfo plSqlErrorInfo = new PlSqlErrorInfo(-1, -1, exception.getLocalizedMessage());
            this.m_results.add(plSqlErrorInfo);
            return false;
        }
        return true;
    }

    public List<PlSqlErrorInfo> getErrors() {
        assert (this.m_results != null);
        return this.m_results;
    }

    public void logErrors(Translator.Log log) {
        assert (this.m_results != null);
        if (this.m_results.size() > 0) {
            IdeStorage ideStorage = new IdeStorage((Node)this.m_node);
            ideStorage.setProperty("PlSqlCompilerPage.URL", (Object)this.m_node.getURL());
            for (PlSqlErrorInfo plSqlErrorInfo : this.m_results) {
                if (plSqlErrorInfo.isWarning()) {
                    log.warning((Storage)ideStorage, plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
                    continue;
                }
                log.error((Storage)ideStorage, plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
            }
            if (this.m_results.size() == 20) {
                log.warning((Storage)ideStorage, 1, 1, 0, DatabaseNavigatorResources.getString("PLSQL_TRANSLATOR_MSGS_EXCEEDED"));
            }
        }
    }
}

