/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net.editor;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.extendedtype.XMLExtendeType;
import oracle.dbtools.raptor.navigator.net.editor.XMLTypeBreakoutEditorAction;
import oracle.dbtools.raptor.navigator.net.editor.XMLTypeURLFileSystemHelper;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.sql.OPAQUE;

public final class XMLTypeNodeFactory {
    static final Logger LOGGER = Logger.getLogger(XMLTypeNodeFactory.class.getName());
    private static NodeListener s_listener = new NodeListener(){

        private void runNodeSavedEvent(NodeEvent nodeEvent) {
            try {
                Node node = nodeEvent.getNode();
                URL uRL = node.getURL();
                XMLTypeBreakoutEditorAction xMLTypeBreakoutEditorAction = XMLTypeNodeFactory.getAction(node);
                if (xMLTypeBreakoutEditorAction != null) {
                    xMLTypeBreakoutEditorAction.setSelectedURL(uRL);
                    XMLTypeNodeFactory.unregisterAction(node);
                    final ArrayList<Editor> arrayList = new ArrayList<Editor>();
                    arrayList.add(xMLTypeBreakoutEditorAction.getEditor());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditorManager.getEditorManager().closeEditors(arrayList);
                        }
                    });
                }
            }
            catch (Exception exception) {
                LOGGER.warning(exception.getLocalizedMessage());
            }
        }

        private void runNodeClosedEvent(NodeEvent nodeEvent) {
            try {
                Node node = nodeEvent.getNode();
                node.removeNodeListener(s_listener);
                XMLTypeBreakoutEditorAction xMLTypeBreakoutEditorAction = XMLTypeNodeFactory.unregisterAction(node);
                if (xMLTypeBreakoutEditorAction != null) {
                    XMLTypeNodeFactory.uncacheNode(xMLTypeBreakoutEditorAction.getXMLExtendeType());
                }
            }
            catch (Exception exception) {
                LOGGER.warning(exception.getLocalizedMessage());
            }
        }

        public void nodeSaved(NodeEvent nodeEvent) {
            this.runNodeSavedEvent(nodeEvent);
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.runNodeClosedEvent(nodeEvent);
        }
    };
    private static Map<Node, XMLTypeBreakoutEditorAction> s_actions = new WeakHashMap<Node, XMLTypeBreakoutEditorAction>();
    private static Map<Object, Node> s_cache = new WeakHashMap<Object, Node>();

    public static Node findOrCreate(URL uRL, XMLTypeBreakoutEditorAction xMLTypeBreakoutEditorAction) throws IllegalAccessException, InstantiationException, IOException {
        URL uRL2 = XMLTypeURLFileSystemHelper.createXMLTypeURL(uRL);
        XMLTypeURLFileSystemHelper.manageURLCleanup(xMLTypeBreakoutEditorAction.getXMLExtendeType(), uRL2);
        Node node = NodeFactory.findOrCreate((URL)uRL2);
        node.addNodeListener(s_listener);
        XMLTypeNodeFactory.registerAction(node, xMLTypeBreakoutEditorAction);
        return node;
    }

    public static Node find(URL uRL) {
        return NodeFactory.find((URL)uRL);
    }

    public static void registerAction(Node node, XMLTypeBreakoutEditorAction xMLTypeBreakoutEditorAction) {
        s_actions.put(node, xMLTypeBreakoutEditorAction);
    }

    static XMLTypeBreakoutEditorAction unregisterAction(Node node) {
        if (node != null) {
            return s_actions.remove(node);
        }
        return null;
    }

    static XMLTypeBreakoutEditorAction getAction(Node node) {
        return s_actions.get(node);
    }

    public static void cacheNode(XMLExtendeType xMLExtendeType, Node node) {
        if (xMLExtendeType != null) {
            OPAQUE oPAQUE = xMLExtendeType.getObjectValue();
            if (oPAQUE != null) {
                s_cache.put(oPAQUE, node);
            } else {
                s_cache.put(xMLExtendeType, node);
            }
        }
    }

    static Node uncacheNode(XMLExtendeType xMLExtendeType) {
        Node node = null;
        if (xMLExtendeType != null) {
            OPAQUE oPAQUE = xMLExtendeType.getObjectValue();
            if (oPAQUE != null) {
                node = s_cache.remove(oPAQUE);
            }
            Node node2 = s_cache.remove(xMLExtendeType);
            if (node == null) {
                node = node2;
            }
        }
        return node;
    }

    public static Node lookupNode(XMLExtendeType xMLExtendeType) {
        Node node = null;
        if (xMLExtendeType != null) {
            OPAQUE oPAQUE;
            URL uRL = xMLExtendeType.getLoadFromURL();
            if (uRL != null) {
                node = XMLTypeNodeFactory.find(uRL);
            }
            if (node == null && (oPAQUE = xMLExtendeType.getObjectValue()) != null) {
                return s_cache.get(oPAQUE);
            }
            if (node == null) {
                return s_cache.get(xMLExtendeType);
            }
        }
        return node;
    }
}

