/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.net.NavigatorFormatHelper;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.ModelUtil;

public abstract class DBURLFormatHelper {
    private static final Map<String, DBURLFormatHelper> s_helpers = new HashMap<String, DBURLFormatHelper>();
    private String m_protocol;

    public static DBURLFormatHelper getHelper(String string) {
        DBURLFormatHelper dBURLFormatHelper = s_helpers.get(string);
        return dBURLFormatHelper;
    }

    private static DBURLFormatHelper getHelper(URL uRL) {
        assert (uRL != null);
        return DBURLFormatHelper.getHelper(uRL.getProtocol());
    }

    public static void registerFormatHelper(String string, DBURLFormatHelper dBURLFormatHelper) {
        s_helpers.put(string, dBURLFormatHelper);
    }

    public static URL getURL(String string, String string2) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(string);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getURLImpl(string2) : null;
    }

    public static URL getURL(String string, String string2, String string3, String string4, String string5) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(string);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getURLImpl(string2, string3, string4, string5);
    }

    public static URL getURL(URL uRL, String string) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getURLImpl(uRL, string);
    }

    public static URL getSiblingURL(URL uRL, String string) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getSiblingURLImpl(uRL, string);
    }

    public static URL getEnclosedTypeURL(URL uRL, String string) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getEnclosedTypeURLImpl(uRL, string);
    }

    public static URL getChildURL(URL uRL, String string, String string2) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getChildURLImpl(uRL, string, string2);
    }

    public static boolean isDBURL(URL uRL) {
        return uRL != null && s_helpers.containsKey(uRL.getProtocol());
    }

    public static String getConnectionName(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getConnectionNameImpl(uRL) : null;
    }

    public static String getCatalog(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getCatalogImpl(uRL) : null;
    }

    public static String getSchema(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getSchemaImpl(uRL) : null;
    }

    public static String getCatalogSchema(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        if (dBURLFormatHelper == null) {
            return null;
        }
        String string = dBURLFormatHelper.getSchemaImpl(uRL);
        String string2 = dBURLFormatHelper.getCatalogImpl(uRL);
        if (string2.length() == 0) {
            return string;
        }
        return string + "_" + string2;
    }

    public static String getBaseType(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getBaseTypeImpl(uRL) : null;
    }

    public static String getName(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getNameImpl(uRL) : null;
    }

    public static Icon getIcon(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getIconImpl(uRL) : null;
    }

    public static String getChildType(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getChildTypeImpl(uRL) : null;
    }

    public static String getChildName(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getChildNameImpl(uRL) : null;
    }

    public static URL getEnclosingURL(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getEnclosingURLImpl(uRL);
    }

    public static URL getTypeURL(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getTypeURLImpl(uRL);
    }

    protected DBURLFormatHelper(String string) {
        assert (string != null);
        this.m_protocol = string;
    }

    protected final String getProtocol() {
        return this.m_protocol;
    }

    protected abstract String getConnectionNameImpl(URL var1);

    protected abstract String getCatalogImpl(URL var1);

    protected abstract String getSchemaImpl(URL var1);

    protected abstract String getBaseTypeImpl(URL var1);

    protected abstract String getNameImpl(URL var1);

    protected abstract Icon getIconImpl(URL var1);

    protected abstract String getChildTypeImpl(URL var1);

    protected abstract String getChildNameImpl(URL var1);

    protected abstract URL getEnclosingURLImpl(URL var1);

    protected URL getURLImpl(String string) {
        return URLFactory.newURL((String)this.m_protocol, (String)DBURLFormatHelper.encode(string));
    }

    protected abstract URL getTypeURLImpl(URL var1);

    protected URL getURLImpl(String string, String string2, String string3, String string4) {
        String string5 = DBURLFormatHelper.encode(string) + "/" + DBURLFormatHelper.encode(string2) + "/" + DBURLFormatHelper.encode(string3);
        if (string4 != null) {
            string5 = string4.equals("PACKAGE+BODY") ? string5 + "/" + string4 : string5 + "/" + DBURLFormatHelper.encode(string4);
        }
        return URLFactory.newURL((String)this.m_protocol, (String)string5);
    }

    protected URL getURLImpl(URL uRL, String string) {
        assert (uRL != null);
        assert (uRL.getPath() != null);
        Object object = uRL.getPath();
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        object = (String)object + DBURLFormatHelper.encode(string);
        return URLFactory.replacePathPart((URL)uRL, (String)object);
    }

    protected URL getChildURLImpl(URL uRL, String string, String string2) {
        assert (uRL != null);
        assert (string != null);
        String string3 = ModelUtil.hasLength((String)string2) ? DBURLFormatHelper.encode(string) + "/" + DBURLFormatHelper.encode(string2) : DBURLFormatHelper.encode(string);
        return URLFactory.replaceRefPart((URL)uRL, (String)string3);
    }

    protected URL getEnclosedTypeURLImpl(URL uRL, String string) {
        assert (uRL != null);
        assert (string != null);
        String string2 = this.getNameImpl(uRL);
        assert (string2 != null);
        Object object = uRL.getPath();
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        object = (String)object + DBURLFormatHelper.encode(string);
        return URLFactory.replacePathPart((URL)uRL, (String)object);
    }

    protected URL getSiblingURLImpl(URL uRL, String string) {
        assert (uRL != null);
        assert (string != null);
        return DBURLFormatHelper.getURL(uRL.getProtocol(), this.getConnectionNameImpl(uRL), this.getCatalogImpl(uRL), this.getSchemaImpl(uRL), string);
    }

    public static String encode(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    protected static String decode(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        try {
            string2 = URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    static {
        DBURLFormatHelper.registerFormatHelper("sqldev.nav", new NavigatorFormatHelper());
    }
}

