/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net;

import java.net.URL;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.net.DBURLStreamHandlerFactory;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;

public class DBRecognizer
extends Recognizer {
    public Class<? extends Node> recognize(URL uRL) {
        Class clazz = null;
        if (DBURLFormatHelper.isDBURL(uRL)) {
            String string = DBURLFormatHelper.getBaseType(uRL);
            String string2 = DBURLFormatHelper.getName(uRL);
            if (string != null && string2 != null) {
                try {
                    ObjectFactory objectFactory = this.getFactory(uRL);
                    if (objectFactory != null) {
                        DatabaseObject databaseObject = objectFactory.getObjectDescriptor(string);
                        Class<? extends Element> clazz2 = databaseObject.getImplementationClass();
                        if (Node.class.isAssignableFrom(clazz2)) {
                            clazz = clazz2.asSubclass(Node.class);
                        }
                        if (clazz == null) {
                            clazz = ObjectNode.class;
                        }
                    } else if (DBURLStreamHandlerFactory.isOracleSource(uRL)) {
                        clazz = PlSqlNode.class;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    public Node create(URL uRL, Class clazz) throws IllegalAccessException, InstantiationException {
        Node node = super.create(uRL, clazz);
        if (node instanceof DatabaseNode) {
            DatabaseNode databaseNode = (DatabaseNode)node;
            ObjectFactory objectFactory = this.getFactory(uRL);
            if (objectFactory == null) {
                return node;
            }
            DBObjectInstance dBObjectInstance = objectFactory.createNodeInstance(DBURLFormatHelper.getBaseType(uRL));
            databaseNode.setNodeInstance(dBObjectInstance);
        }
        return node;
    }

    private ObjectFactory getFactory(URL uRL) {
        ObjectFactory objectFactory = null;
        if (DBURLFormatHelper.isDBURL(uRL)) {
            try {
                String string = DBURLFormatHelper.getConnectionName(uRL);
                Connections connections = Connections.getInstance();
                if (connections.isConnectionOpen(string)) {
                    objectFactory = ObjectFactory.getFactory(string, connections.getConnection(string));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectFactory;
    }
}

