/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class SchemaFolder
extends DefaultFolder
implements DatabaseElement,
Subject {
    private String m_cName;
    private String m_schema;
    private Subject m_subjectProxy = new IdeSubject();
    private URL m_url;
    private DBSchemaInstance m_inst;

    public SchemaFolder(URL uRL, DBSchemaInstance dBSchemaInstance, String string) {
        this.setURL(uRL);
        this.m_inst = dBSchemaInstance;
        this.setProperty("ConnectionType", string);
    }

    public DBSchemaInstance getSchemaInstance() {
        return this.m_inst;
    }

    public String getShortLabel() {
        return this.m_schema;
    }

    @Override
    public void setProperty(String string, Object object) {
        this.m_inst.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) {
        Object object = null;
        object = "SCHEMA".equals(string) ? this.m_schema : ("ConnectionName".equals(string) ? this.m_cName : this.m_inst.getProperty(string));
        return object;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_schema = DBURLFormatHelper.getSchema(uRL);
        this.m_url = uRL;
    }

    public Icon getIcon() {
        return this.m_inst.getDescriptor().getIcon();
    }

    public String getObjectType() {
        return "SCHEMA";
    }

    public Object getProviderIdentifier() {
        return this.getProperty("ConnectionName");
    }

    public String getProviderType() {
        return "db";
    }

    public String getStoreName() {
        return Connections.getStoreName((String)this.getProperty("ConnectionName"));
    }

    public String getSchemaName() {
        return (String)this.getProperty("SCHEMA");
    }

    public void attach(Observer observer) {
        this.m_subjectProxy.attach(observer);
    }

    public void detach(Observer observer) {
        this.m_subjectProxy.detach(observer);
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.m_subjectProxy.notifyObservers(object, updateMessage);
    }
}

