/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.Icon;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.db.model.BaseDBObjectNode;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.ModelUtil;

public final class ObjectNode
extends BaseDBObjectNode
implements DatabaseNode {
    private String m_name;
    private String m_cName;
    private String m_type;
    private String m_schema;
    private static final HashMap<String, String> resource = new HashMap();
    public static final String UNKOWN_OBJECTNODE = "Unknown ObjectNode";
    private DBObjectInstance m_node;
    private boolean m_isFolder = true;
    private static final String LONG_DISPLAY_FORMAT = "{0} {1}.{2}@{3}";
    public static final String DBOBJECT_KEY = "DBObject";
    public static final String PROVIDER_KEY = "DBObjectProvider";

    protected void setIsFolder(boolean bl) {
        this.m_isFolder = bl;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this.m_name = DBURLFormatHelper.getName(uRL);
        this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_type = DBURLFormatHelper.getBaseType(uRL);
        this.m_schema = DBURLFormatHelper.getSchema(uRL);
    }

    @Override
    public void setNodeInstance(DBObjectInstance dBObjectInstance) {
        IconOverlayTracker iconOverlayTracker;
        DBObjectInstance dBObjectInstance2 = this.m_node;
        this.m_node = dBObjectInstance;
        if (dBObjectInstance2 != null && ModelUtil.areDifferent((Object)dBObjectInstance2, (Object)this.m_node)) {
            UpdateMessage.fireStructureChanged((Subject)this);
            if (ModelUtil.areDifferent((Object)dBObjectInstance2.getProperty("INVALID"), (Object)this.m_node.getProperty("INVALID")) && (iconOverlayTracker = DatabaseOverlayClient.getTracker()) != null) {
                iconOverlayTracker.validateOverlay((Element)this);
                iconOverlayTracker.repaintOverlays();
            }
        }
        this.m_isFolder = (iconOverlayTracker = ((DatabaseObject)this.m_node.getDescriptor()).getChildTypes()) != null && ((ChildType[])iconOverlayTracker).length > 0;
    }

    @Override
    public DBObjectInstance getNodeInstance() {
        return this.m_node;
    }

    public Icon getIcon() {
        ConnectionTypeDetails connectionTypeDetails = this.m_node.getObjectFactory().getConnectionTypeDescriptor().getImpl();
        Icon icon = connectionTypeDetails.getIcon(this.m_node);
        return icon == null ? this.m_node.getDescriptor().getIcon() : icon;
    }

    @Override
    public void setProperty(String string, Object object) {
        this.m_node.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) {
        Object object = null;
        if ("INTERNAL_NAME".equals(string)) {
            object = this.m_name;
        } else if ("SCHEMA".equals(string)) {
            object = this.m_schema;
        } else if ("TYPE".equals(string)) {
            Object object2 = object = this.m_node != null ? this.m_node.getProperty("TYPE") : null;
            if (object == null) {
                object = this.m_type;
            }
        } else {
            object = "ConnectionName".equals(string) ? this.m_cName : (DBOBJECT_KEY.equals(string) ? this.getDBObject() : (PROVIDER_KEY.equals(string) ? this.getProvider() : this.m_node.getProperty(string)));
        }
        return object;
    }

    public String getToolTipText() {
        return this.m_node.getProperty("TOOLTIP") != null && !this.m_node.getProperty("TOOLTIP").equals("") ? (String)this.m_node.getProperty("TOOLTIP") : ObjectNode.getDefaultLongDisplay(this.getURL(), this.getShortLabel());
    }

    public static String getDefaultLongDisplay(URL uRL, String string) {
        String string2 = Connections.getDisplayName(DBURLFormatHelper.getConnectionName(uRL));
        String string3 = DBURLFormatHelper.getBaseType(uRL);
        String string4 = DBURLFormatHelper.getSchema(uRL);
        String string5 = string != null ? string : DBURLFormatHelper.getName(uRL);
        String string6 = resource.get(string3);
        String string7 = string6 != null ? Messages.getString(string6) : null;
        return MessageFormat.format(LONG_DISPLAY_FORMAT, string7 != null ? string7 : string3, string4, string5, string2);
    }

    public String getLongLabel() {
        return this.m_node.getProperty("LONG_NAME") != null && !this.m_node.getProperty("LONG_NAME").equals("") ? (String)this.m_node.getProperty("LONG_NAME") : ObjectNode.getDefaultLongDisplay(this.getURL(), this.getShortLabel());
    }

    public boolean mayHaveChildren() {
        return this.m_isFolder;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public String getShortLabel() {
        if (this.m_node != null) {
            if (this.m_node.getProperty("SHORT_NAME") != null && !this.m_node.getProperty("SHORT_NAME").equals("")) {
                return (String)this.m_node.getProperty("SHORT_NAME");
            }
            return this.m_name;
        }
        return UNKOWN_OBJECTNODE;
    }

    public String getObjectName() {
        return (String)this.getProperty("INTERNAL_NAME");
    }

    public Object getProviderIdentifier() {
        return this.getConnectionName();
    }

    public String getStoreName() {
        return Connections.getStoreName(this.getConnectionName());
    }

    public String getObjectType() {
        return (String)this.getProperty("TYPE");
    }

    public String getSchemaName() {
        return (String)this.getProperty("SCHEMA");
    }

    static {
        resource.put("TABLE", "Navigator.Table");
        resource.put("VIEW", "Navigator.View");
        resource.put("DATABASE LINK", "Navigator.Dblink");
        resource.put("DIRECTORY", "Navigator.Directory");
        resource.put("FUNCTION", "Navigator.Function");
        resource.put("INDEX", "Navigator.Index");
        resource.put("QUEUE", "Navigator.Queue");
        resource.put("QUEUE TABLE", "Navigator.QueueTable");
        resource.put("JAVA", "Navigator.Java");
        resource.put("MATERIALIZED VIEW", "Navigator.MatView");
        resource.put("MATERIALIZED VIEW LOG", "Navigator.MatViewLog");
        resource.put("PACKAGE", "Navigator.Package");
        resource.put("PACKAGE BODY", "Navigator.PkgBody");
        resource.put("BLOCK", "Navigator.PkgBlk");
        resource.put("PROCEDURE", "Navigator.Procedure");
        resource.put("RECYCLEBIN", "Navigator.Rcbin");
        resource.put("SCHEMAS", "Navigator.Schemas");
        resource.put("SEQUENCE", "Navigator.Seq");
        resource.put("SYNONYM", "Navigator.Syn");
        resource.put("TRIGGER", "Navigator.Trigger");
        resource.put("TYPE", "Navigator.Type");
        resource.put("APEX", "Navigator.apex");
        resource.put("JOBS", "Navigator.Job");
        resource.put("XML SCHEMA", "Navigator.xmlschema");
    }
}

