/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.AbstractNodeImpl;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderOwner;
import oracle.dbtools.raptor.navigator.db.xml.XmlNodeImpl;
import oracle.dbtools.xml.navigator.FolderOwner;
import oracle.dbtools.xml.navigator.NodeElement;
import oracle.dbtools.xml.navigator.ObjectTypeElement;

public class XmlObjectType
extends XmlFolderOwner
implements ObjectType {
    private String m_type;
    private DatabaseObject m_nodeImpl;

    public XmlObjectType(String string, String string2, NavigatorDescriptor navigatorDescriptor, ObjectTypeElement objectTypeElement) {
        super(string, navigatorDescriptor, (FolderOwner)objectTypeElement);
        this.m_type = string2;
        this.initNode(objectTypeElement.getNode());
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public DatabaseObject getNode() {
        return this.m_nodeImpl;
    }

    private void initNode(NodeElement nodeElement) {
        if (nodeElement != null) {
            XmlNodeImpl xmlNodeImpl = new XmlNodeImpl(this, this.m_desc, nodeElement);
            Class<? extends DatabaseObject> clazz = xmlNodeImpl.getDBObjectImplementationClass();
            if (clazz != null) {
                assert (AbstractNodeImpl.class.isAssignableFrom(clazz));
                try {
                    AbstractNodeImpl abstractNodeImpl = (AbstractNodeImpl)clazz.newInstance();
                    abstractNodeImpl.setItemDelegate(xmlNodeImpl);
                    this.m_nodeImpl = abstractNodeImpl;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.m_nodeImpl = xmlNodeImpl;
                }
            } else {
                this.m_nodeImpl = xmlNodeImpl;
            }
        }
    }

    @Override
    boolean isIncludesSynonyms() {
        return this.m_includesSyns;
    }

    @Override
    public DatabaseFolder[] getFolders() {
        return this.getFoldersImpl();
    }
}

