/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.XmlChildImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlDBObject;
import oracle.dbtools.raptor.navigator.db.xml.XmlDatabaseItem;
import oracle.dbtools.raptor.navigator.db.xml.XmlObjectType;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.xml.navigator.ChildTypeElement;
import oracle.dbtools.xml.navigator.ItemDescriptor;
import oracle.dbtools.xml.navigator.NavigatorXmlElements;
import oracle.dbtools.xml.navigator.NodeElement;
import oracle.ide.model.Element;
import oracle.javatools.util.ModelUtil;

public class XmlNodeImpl
extends XmlDatabaseItem
implements XmlDBObject,
NavigatorXmlElements {
    private XmlObjectType m_type;
    private List<XmlChildImpl> m_childTypes = new ArrayList<XmlChildImpl>();
    private String m_nodeClassName;
    private Class<? extends Element> m_nodeClass;
    private String m_implClassName;
    private Class<? extends DatabaseObject> m_implClass;
    private String m_instClassName;
    private Class<? extends DBObjectInstance> m_instClass;

    protected XmlNodeImpl(XmlObjectType xmlObjectType, NavigatorDescriptor navigatorDescriptor, NodeElement nodeElement) {
        super((ItemDescriptor)nodeElement, navigatorDescriptor, xmlObjectType.getType());
        this.m_type = xmlObjectType;
        this.m_nodeClassName = nodeElement.getNodeClass();
        this.m_implClassName = nodeElement.getImplementationClass();
        this.m_instClassName = nodeElement.getInstanceClass();
        for (ChildTypeElement childTypeElement : nodeElement.getChildTypes()) {
            String string = childTypeElement.getName();
            this.m_childTypes.add(new XmlChildImpl(string, navigatorDescriptor, xmlObjectType.getType(), childTypeElement));
        }
    }

    @Override
    public ChildType[] getChildTypes() {
        return this.m_childTypes.toArray(new ChildType[0]);
    }

    @Override
    public ChildType getChildType(String string) {
        return this.getChildTypeImpl(string);
    }

    private XmlChildImpl getChildTypeImpl(String string) {
        for (XmlChildImpl xmlChildImpl : this.m_childTypes) {
            if (!ModelUtil.areEqual((Object)string, (Object)xmlChildImpl.getChildType())) continue;
            return xmlChildImpl;
        }
        return null;
    }

    @Override
    public Class<? extends Element> getImplementationClass() {
        if (this.m_nodeClass == null && this.m_nodeClassName != null) {
            try {
                this.m_nodeClass = Class.forName(this.m_nodeClassName, true, this.getDescriptor().getDescriptorClassLoader()).asSubclass(Element.class);
                assert (DatabaseNode.class.isAssignableFrom(this.m_nodeClass));
                DBNavigatorManager.registerDatabaseNodeSubtype(this.m_type.getType(), this.m_nodeClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_nodeClass;
    }

    Class<? extends DatabaseObject> getDBObjectImplementationClass() {
        if (this.m_implClass == null && this.m_implClassName != null) {
            try {
                this.m_implClass = Class.forName(this.m_implClassName, true, this.getDescriptor().getDescriptorClassLoader()).asSubclass(DatabaseObject.class);
                assert (DatabaseObject.class.isAssignableFrom(this.m_implClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_implClass;
    }

    @Override
    public Class<? extends DBObjectInstance> getDBObjectInstanceClass() {
        if (this.m_instClass == null && this.m_instClassName != null) {
            try {
                this.m_instClass = Class.forName(this.m_instClassName, true, this.getDescriptor().getDescriptorClassLoader()).asSubclass(DBObjectInstance.class);
                assert (DBObjectInstance.class.isAssignableFrom(this.m_instClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_instClass;
    }

    @Override
    public Class<? extends FilterChildProvider> getChildProvider(String string) {
        XmlChildImpl xmlChildImpl = this.getChildTypeImpl(string);
        return xmlChildImpl != null ? xmlChildImpl.getProviderImpl() : null;
    }
}

