/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.db.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.XmlDatabaseItem;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.xml.navigator.ChildTypeElement;
import oracle.dbtools.xml.navigator.IconElement;
import oracle.dbtools.xml.navigator.ItemDescriptor;
import oracle.dbtools.xml.navigator.LabelElement;

public class XmlChildImpl
extends XmlDatabaseItem
implements ChildType {
    private ObjectQueries m_queries;
    private String m_nodeType;
    private String m_childType;
    private boolean m_showFolder;
    private String m_labelKey;
    private String m_label;
    private String m_iconKey;
    private String m_iconPath;
    private Icon m_icon;
    private String m_provImpl;
    private Class<? extends FilterChildProvider> m_provImplClass;

    XmlChildImpl(String string, NavigatorDescriptor navigatorDescriptor, String string2, ChildTypeElement childTypeElement) {
        super((ItemDescriptor)childTypeElement, navigatorDescriptor, string2);
        IconElement iconElement;
        this.m_queries = childTypeElement.getQueries();
        this.m_nodeType = childTypeElement.getNodeType();
        this.m_childType = string;
        this.m_provImpl = childTypeElement.getProviderImplementationClass();
        this.m_showFolder = childTypeElement.isShowFolder();
        LabelElement labelElement = childTypeElement.getFolderLabel();
        if (labelElement != null) {
            this.m_labelKey = labelElement.getKey();
        }
        if ((iconElement = childTypeElement.getFolderIcon()) != null) {
            this.m_iconKey = iconElement.getKey();
            if (this.m_iconKey == null) {
                this.m_iconPath = iconElement.getPath();
            }
        }
    }

    ObjectQueries getQueries() {
        if (this.m_queries.getLoadedQueryCount() == 0) {
            this.m_queries.initQueries(null);
        }
        return this.m_queries;
    }

    @Override
    public String getNodeType() {
        return this.m_nodeType;
    }

    @Override
    public boolean hasChildListOverride() {
        return this.getQueries().getLoadedQueryCount() > 0;
    }

    @Override
    public String getChildType() {
        return this.m_childType;
    }

    Class<? extends FilterChildProvider> getProviderImpl() {
        if (this.m_provImplClass == null && this.m_provImpl != null) {
            try {
                this.m_provImplClass = Class.forName(this.m_provImpl, true, this.getDescriptor().getDescriptorClassLoader());
                assert (FilterChildProvider.class.isAssignableFrom(this.m_provImplClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_provImplClass;
    }

    @Override
    public boolean showAsFolder() {
        return this.m_showFolder;
    }

    @Override
    public Icon getFolderIcon() {
        if (this.m_icon == null) {
            if (this.m_iconKey != null) {
                this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconKey, this.getDescriptor());
            } else if (this.m_iconPath != null) {
                this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconPath);
            }
        }
        return this.m_icon;
    }

    @Override
    public String getFolderLabel() {
        if (this.m_label == null) {
            NavigatorDescriptor navigatorDescriptor = this.getDescriptor();
            this.m_label = navigatorDescriptor != null && this.m_labelKey != null ? navigatorDescriptor.getResource(this.m_labelKey) : this.m_childType;
        }
        return this.m_label;
    }
}

