/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.jdbc.AbstractJDBCFolderInstance;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCDBFolder;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCNavProvider;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseItem;

public class JDBCProceduresFolderInstance
extends AbstractJDBCFolderInstance {
    private static DatabaseItem s_procedureItem = new JDBCDBFolder(RaptorImagesArb.getIcon("PROCEDURE_FOLDER"), "Procedures", "Procedure");

    public JDBCProceduresFolderInstance(ObjectFactory objectFactory, JDBCDBFolder jDBCDBFolder) {
        super(objectFactory, jDBCDBFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DBObjectInstance> getChildren() {
        ResultSet resultSet = null;
        ArrayList<DBObjectInstance> arrayList = new ArrayList<DBObjectInstance>();
        ObjectFactory objectFactory = this.getObjectFactory();
        Connection connection = objectFactory.getConnection();
        try {
            resultSet = connection.getMetaData().getProcedures(connection.getCatalog(), objectFactory.getSchema(), "%");
            while (resultSet.next()) {
                String string = resultSet.getString(3);
                DBObjectInstance dBObjectInstance = objectFactory.createNodeInstance(this.getType());
                dBObjectInstance.setProperty("NAME", string);
                for (String string2 : this.getPropertyKeys()) {
                    dBObjectInstance.setProperty(string2, this.getProperty(string2));
                }
                arrayList.add(dBObjectInstance);
            }
        }
        catch (SQLException sQLException) {
            JDBCNavProvider.LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList;
    }

    @Override
    public DatabaseItem getDescriptor() {
        return s_procedureItem;
    }
}

