/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.impl.TypeContainerTreeNode;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Element;

public class CategoryTreeNode
extends TypeContainerTreeNode {
    public DBSchemaInstance getSchemaInstance() {
        SchemaFolder schemaFolder = (SchemaFolder)this.getElement();
        return schemaFolder.getSchemaInstance();
    }

    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        CategoryFolder categoryFolder = (CategoryFolder)this.getElement();
        if (!categoryFolder.getCategoryInstance().canLoadChildren()) {
            return null;
        }
        return new LoadTask(categoryFolder, (String)categoryFolder.getProviderIdentifier());
    }

    private class LoadTask
    extends NavigatorQueryTask {
        private CategoryFolder m_parent;

        protected LoadTask(CategoryFolder categoryFolder, String string) {
            super(DatabaseNavigatorResources.getString("CONNECTION_FILTER_OPEN"), string, true);
            this.m_parent = categoryFolder;
        }

        @Override
        protected Collection<Element> doWorkImpl() throws TaskException {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            URL uRL = this.m_parent.getURL();
            String string = DBURLFormatHelper.getConnectionName(uRL);
            CategoryInstance categoryInstance = this.m_parent.getCategoryInstance();
            ObjectFactory objectFactory = categoryInstance.getObjectFactory();
            if (objectFactory != null) {
                String string2;
                String string3 = (String)categoryInstance.getProperty("CATALOG");
                if (string3 == null) {
                    string3 = DBURLFormatHelper.getCatalog(uRL);
                }
                if ((string2 = (String)categoryInstance.getProperty("SCHEMA")) == null) {
                    string2 = DBURLFormatHelper.getSchema(uRL);
                }
                String string4 = string3;
                String string5 = string2;
                arrayList.addAll(CategoryTreeNode.this.loadTypeFolders(categoryInstance, string, string4, string5));
                String string6 = CategoryTreeNode.this.getURLProtocol();
                if (string6 != null) {
                    for (CategoryInstance categoryInstance2 : categoryInstance.listCategories()) {
                        URL uRL2 = DBURLFormatHelper.getURL(string6, string, string4, string5, categoryInstance2.getDescriptor().getType());
                        arrayList.add(new CategoryFolder(uRL2, categoryInstance2));
                    }
                }
            }
            return arrayList;
        }
    }
}

