/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.awt.Component;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.db.AbstractDBViewController;
import oracle.dbtools.raptor.navigator.db.DBViewControllerImpl;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeSupport;
import oracle.dbtools.raptor.navigator.db.GroupedConnections;
import oracle.dbtools.raptor.navigator.db.TypedConnections;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.TextNode;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;

class NavigatorMenuListener
implements ContextMenuListener {
    NavigatorMenuListener() {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        IdeAction ideAction;
        Context context = contextMenu.getContext();
        NavigatorConstants.removeNewMenuItem((ContextMenu)contextMenu);
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 0) {
            return;
        }
        boolean bl = elementArray.length > 1;
        Element element = elementArray[0];
        if (element instanceof GroupedConnections) {
            View view = context.getView();
            String string = DatabaseNavigatorResources.getString("NEW_SUBMENU_LABEL");
            JMenu jMenu = contextMenu.createSubMenu(StringUtils.stripMnemonic((String)string), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)string)));
            List<String> list = DatabaseTypeSupport.getSupportedDatabaseTypes();
            for (String string2 : list) {
                IdeAction ideAction2 = DatabaseTypeSupport.getLocalNewAction(string2, view, true);
                jMenu.add(contextMenu.createMenuItem((ToggleAction)ideAction2));
            }
            contextMenu.add((Component)jMenu, 1.0f);
        } else if (element instanceof TypedConnections) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DBViewControllerImpl.ACTION_NEW_CONN), 1.0f);
        } else if (element instanceof Databases) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DBViewControllerImpl.ACTION_NEW_CONN), 1.0f);
        } else if (!bl && element instanceof DatabaseConnection) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DBViewControllerImpl.ACTION_CONNECT, 1.0f), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DBViewControllerImpl.ACTION_DISCONNECT, 1.1f), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)DBViewControllerImpl.ACTION_RECONNECT, 1.1f), 1.0f);
            contextMenu.add((Component)this.createMenu((MenuManager)contextMenu, 20), 1.0f);
            this.addAction(contextMenu, 56, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            this.addAction(contextMenu, AbstractDBViewController.FILTER_CMD_ID, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            this.addAction(contextMenu, AbstractDBViewController.CLEAR_FILTER_CMD_ID, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
        } else if (!bl && element instanceof DatabaseFolder) {
            Object object;
            if (!((DatabaseFolder)element).getObjectType().equals("TABLESPACE") && (object = DBViewControllerImpl.getCreateActionProvider().getNewAction(element)) != null) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)object), 1.0f);
                object.updateAction(contextMenu.getContext());
            }
            this.addAction(contextMenu, 51, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            if (!((ObjectFolder)element).getURL().toString().toLowerCase().startsWith("sqldev.migration") && (object = ((ObjectFolder)element).getFolderInstance()).canHaveFilter()) {
                this.addAction(contextMenu, AbstractDBViewController.FILTER_CMD_ID, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                this.addAction(contextMenu, AbstractDBViewController.CLEAR_FILTER_CMD_ID, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            }
        } else if (!bl && element instanceof CategoryFolder) {
            this.addAction(contextMenu, 51, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
        } else if (element instanceof OtherSchemasFolder) {
            this.addAction(contextMenu, 51, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            this.addAction(contextMenu, AbstractDBViewController.FILTER_CMD_ID, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            this.addAction(contextMenu, AbstractDBViewController.CLEAR_FILTER_CMD_ID, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
        } else if (element instanceof SchemaFolder) {
            if (!((SchemaFolder)element).getURL().toString().toLowerCase().startsWith("sqldev.migration")) {
                this.addAction(contextMenu, AbstractDBViewController.FILTER_CMD_ID, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                this.addAction(contextMenu, AbstractDBViewController.CLEAR_FILTER_CMD_ID, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            }
        } else if (!bl && (ideAction = DBViewControllerImpl.getCreateActionProvider().getEditAction(element)) != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, 1.0f), element instanceof TextNode ? 1.0f : MenuConstants.SECTION_EDIT_CTXT_MENU);
        }
    }

    private void addAction(ContextMenu contextMenu, int n, float f) {
        IdeAction ideAction = IdeAction.find((int)n);
        if (ideAction != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction), f);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    private JMenuItem createMenu(MenuManager menuManager, int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        return ideAction != null ? menuManager.createMenuItem((ToggleAction)ideAction) : null;
    }
}

