/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.core;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Iterator;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.impl.ConnectionStoresTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.util.GCTracker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.javatools.clipboard.ClipboardStack;

final class NavigatorViewController
implements Controller {
    public static final String COLLAPSE_ALL_NODES_CMD = "Navigator.COLLAPSE_ALL_NODES";
    public static final int COLLAPSE_ALL_NODES_CMD_ID = Ide.findOrCreateCmdID((String)"Navigator.COLLAPSE_ALL_NODES");
    private NavigatorWindow m_view;

    NavigatorViewController(NavigatorWindow navigatorWindow) {
        this.m_view = navigatorWindow;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (context.getView() == this.m_view) {
            int n = ideAction.getCommandId();
            if (n == 51) {
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
                if (navigatorTreeNode != null) {
                    this.m_view.getTree().refresh(navigatorTreeNode);
                    if (navigatorTreeNode.getParent() instanceof ConnectionStoresTreeNode) {
                        System.gc();
                        GCTracker.getInstance().pollReferentReapQueue();
                    }
                }
                bl = true;
            } else if (n == COLLAPSE_ALL_NODES_CMD_ID) {
                this.collapseAllNodes();
                bl = true;
            } else if (n == 18) {
                Object object;
                String string = null;
                Element[] elementArray = context.getSelection();
                if (elementArray != null && elementArray.length > 0) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(elementArray[0]);
                    for (int i = 1; i < elementArray.length; ++i) {
                        ((StringBuilder)object).append(", ").append(elementArray[i]);
                    }
                    string = ((StringBuilder)object).toString();
                }
                if (string != null) {
                    object = new StringSelection(string);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    ClipboardStack.pushCurrentClipboard();
                    clipboard.setContents((Transferable)object, (ClipboardOwner)object);
                }
            }
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (context.getView() == this.m_view) {
            int n = ideAction.getCommandId();
            if (n == 51) {
                boolean bl2 = false;
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
                bl2 = navigatorTreeNode != null && !navigatorTreeNode.isLeaf();
                ideAction.setEnabled(bl2);
                bl = true;
            } else if (n == COLLAPSE_ALL_NODES_CMD_ID) {
                ideAction.setEnabled(true);
                bl = true;
            } else if (n == 18) {
                boolean bl3 = false;
                Element[] elementArray = context.getSelection();
                if (elementArray != null && elementArray.length > 0) {
                    bl3 = true;
                }
                ideAction.setEnabled(bl3);
                bl = true;
            }
        }
        return bl;
    }

    private void collapseAllNodes() {
        NavigatorTree navigatorTree = this.m_view.getTree();
        NavigatorTreeNode navigatorTreeNode = navigatorTree.getRoot();
        this.collapseNode(navigatorTree, navigatorTreeNode);
    }

    private void collapseNode(NavigatorTree navigatorTree, NavigatorTreeNode navigatorTreeNode) {
        if (this.m_view.canCollapse(navigatorTreeNode)) {
            navigatorTree.collapse(navigatorTreeNode, false);
        } else if (navigatorTreeNode.getChildCount() > 0) {
            Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
            while (iterator.hasNext()) {
                this.collapseNode(navigatorTree, iterator.next());
            }
        }
    }
}

