/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.core;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controls.WaitCursor;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.explorer.IconOverlayTreeCellRenderer;
import oracle.ide.model.Element;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.dnd.DragDropListener;
import oracle.ideimpl.explorer.dnd.JTreeDragHandler;
import oracle.ideimpl.explorer.dnd.JTreeDropHandler;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.ui.KeyNavigationManager;
import oracle.javatools.ui.themes.Themes;

final class NavigatorUI
extends View
implements IconOverlayConsumer,
KeyListener,
TreeSelectionListener,
TreeExpansionListener,
MouseListener,
ActionListener,
FocusListener,
DragDropListener {
    private JScrollPane m_gui = new JScrollPane();
    private IconOverlayCache m_overlayCache;
    private KeyNavigationManager m_keyMgr;
    private NavigatorTree m_tree;
    private CustomTree m_treeUI;

    NavigatorUI(View view) {
        this.setOwner(view);
        if (Themes.isThemed()) {
            this.m_gui.setOpaque(false);
            this.m_gui.getViewport().setOpaque(false);
        }
        this.m_gui.setBorder(BorderFactory.createEmptyBorder());
    }

    public Component getGUI() {
        return this.m_gui;
    }

    void setTree(NavigatorTree navigatorTree) {
        this.m_tree = navigatorTree;
        this.m_treeUI = navigatorTree.getTree();
        this.m_treeUI.putClientProperty("JTree.expandOnMouseRelease", Boolean.TRUE);
        if (this.m_overlayCache != null) {
            this.m_overlayCache.registerOverlayConsumer((IconOverlayConsumer)this);
            this.m_treeUI.setCellRenderer((TreeCellRenderer)new IconOverlayTreeCellRenderer((IconOverlayConsumer)this, (DefaultTreeCellRenderer)this.m_treeUI.getCellRenderer()));
        }
        this.m_treeUI.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.installTreeKeyManager();
        this.m_treeUI.addTreeExpansionListener(this);
        this.m_treeUI.addTreeSelectionListener(this);
        this.m_treeUI.setPreMouseListener(this);
        this.m_treeUI.setScrollsOnExpand(true);
        this.m_gui.setViewportView((Component)((Object)this.m_treeUI));
        this.m_treeUI.setShowsRootHandles(false);
        new JTreeDragHandler((JTree)((Object)this.m_treeUI), 3, (DragDropListener)this);
        new JTreeDropHandler((JTree)((Object)this.m_treeUI), 3);
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        NavigatorContext.initializeContext(context, this.m_tree, this.getTreeNodeSelectioFromUI());
        return context;
    }

    public ContextMenu getContextMenu() {
        View view = this.owner();
        return view != null ? view.getContextMenu() : null;
    }

    protected Element[] getSelectionFromUI() {
        NavigatorTreeNode[] navigatorTreeNodeArray = this.getTreeNodeSelectioFromUI();
        Element[] elementArray = new Element[navigatorTreeNodeArray.length];
        for (int i = 0; i < elementArray.length; ++i) {
            elementArray[i] = navigatorTreeNodeArray[i].getElement();
        }
        return elementArray;
    }

    private NavigatorTreeNode[] getTreeNodeSelectioFromUI() {
        TreePath[] treePathArray = this.m_treeUI.getSelectionPaths();
        NavigatorTreeNode[] navigatorTreeNodeArray = new NavigatorTreeNode[treePathArray != null ? treePathArray.length : 0];
        for (int i = 0; i < navigatorTreeNodeArray.length; ++i) {
            NavigatorTreeNode navigatorTreeNode;
            navigatorTreeNodeArray[i] = navigatorTreeNode = (NavigatorTreeNode)treePathArray[i].getLastPathComponent();
        }
        return navigatorTreeNodeArray;
    }

    public final IconOverlayCache getOverlayCache() {
        return this.m_overlayCache;
    }

    public final void setOverlayCache(IconOverlayCache iconOverlayCache) {
        this.m_overlayCache = iconOverlayCache;
    }

    public Element getElement(Object object) {
        if (object instanceof NavigatorTreeNode) {
            return ((NavigatorTreeNode)object).getElement();
        }
        return null;
    }

    public JTree getJTree() {
        return this.m_treeUI;
    }

    private void installTreeKeyManager() {
        CustomTreeKeyNavigation customTreeKeyNavigation = new CustomTreeKeyNavigation((JTree)((Object)this.m_treeUI));
        this.m_keyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)customTreeKeyNavigation);
        this.m_treeUI.setPreKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                NavigatorUI.this.m_keyMgr.preKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                NavigatorUI.this.m_keyMgr.preKeyReleased(keyEvent);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                NavigatorUI.this.m_keyMgr.preKeyTyped(keyEvent);
            }
        });
        this.m_treeUI.setPostKeyListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateSelection();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.focusGained(focusEvent);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.scheduleUpdateSelection();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n;
        this.m_keyMgr.postKeyPressed(keyEvent);
        if (!keyEvent.isConsumed() && (n = keyEvent.getKeyCode()) == 10) {
            this.fireDefaultAction(keyEvent);
        }
    }

    private void fireDefaultAction(InputEvent inputEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu == null) {
            return;
        }
        View view = this.owner();
        Context context = view != null ? view.getContext((EventObject)inputEvent) : this.getContext();
        NavigatorUI.navigateToLeafNode(context);
    }

    private static void navigateToLeafNode(Context context) {
        DatabaseSourceNode databaseSourceNode;
        NavigatorTreeNode navigatorTreeNode;
        NavigationPoint navigationPoint = null;
        Element element = context.getElement();
        if (element instanceof ChildObjectElement && (navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context)) != null && (databaseSourceNode = navigatorTreeNode.findAncestorElement(DatabaseSourceNode.class, true)) != null) {
            navigationPoint = databaseSourceNode.getNavigationPoint((ChildObjectElement)element);
        }
        if (navigationPoint != null) {
            navigatorTreeNode = NavigationManager.getNavigationManager();
            try {
                if (navigatorTreeNode != null) {
                    navigatorTreeNode.navigateTo(navigationPoint);
                } else {
                    navigationPoint.navigate();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(NavigatorUI.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.m_keyMgr.postKeyTyped(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.m_keyMgr.postKeyReleased(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dblClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            if (this.m_treeUI.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null) {
                WaitCursor waitCursor;
                boolean bl = Ide.isStarting() || !Ide.getIdeArgs().getCreateUI();
                WaitCursor waitCursor2 = waitCursor = !bl ? new WaitCursor((Component)Ide.getMainWindow()) : null;
                if (waitCursor != null) {
                    waitCursor.show();
                }
                try {
                    this.fireDefaultAction(mouseEvent);
                }
                finally {
                    if (waitCursor != null) {
                        waitCursor.hide();
                    }
                }
            }
        } else if (mouseEvent.getClickCount() > 2) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.tryPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.dblClicked(mouseEvent);
        } else {
            this.tryPopup(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void tryPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            View view;
            Context context;
            ContextMenu contextMenu = this.getContextMenu();
            if (contextMenu == null) {
                return;
            }
            TreePath treePath = this.m_treeUI.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.tryPopupInBlankSpace(contextMenu, mouseEvent);
                return;
            }
            TreePath[] treePathArray = this.m_treeUI.getSelectionPaths();
            boolean bl = false;
            if (treePathArray != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    if (treePathArray[i].getLastPathComponent() != treePath.getLastPathComponent()) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                this.m_treeUI.setSelectionPath(treePath);
            }
            Context context2 = context = (view = this.owner()) != null ? view.getContext((EventObject)mouseEvent) : this.getContext(mouseEvent);
            if (context.getElement() == null) {
                return;
            }
            contextMenu.show(context);
        }
    }

    protected void tryPopupInBlankSpace(ContextMenu contextMenu, MouseEvent mouseEvent) {
    }

    public Transferable[] dragStarted(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        if (this.m_treeUI.getPathForLocation(point.x, point.y) == null) {
            return new Transferable[0];
        }
        Context context = this.getContext(dragGestureEvent);
        TransferableContext transferableContext = new TransferableContext(context);
        final InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        Transferable transferable = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DndUtils.FLAVOR_TRIGGER_EVENT};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DndUtils.FLAVOR_TRIGGER_EVENT.equals(dataFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(dataFlavor)) {
                    return inputEvent;
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }
        };
        return new Transferable[]{transferableContext, transferable};
    }

    public void dropOccurred(DragSourceDropEvent dragSourceDropEvent, Object object) {
        if (dragSourceDropEvent.getDropSuccess()) {
            this.m_tree.getModel().nodeChanged((NavigatorTreeNode)object);
        }
    }

    private static final class CustomTreeKeyNavigation
    extends KeyNavigationManager.TreeKeyAdapter {
        public CustomTreeKeyNavigation(JTree jTree) {
            super(jTree);
        }

        public String toString(Object object) {
            TreePath treePath = (TreePath)object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            String string = null;
            Object object2 = defaultMutableTreeNode.getUserObject();
            string = object2 != null ? ((Element)object2).getShortLabel() : "";
            return string;
        }
    }
}

