/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.core;

import oracle.dbtools.raptor.navigator.core.NavigatorManager;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;

public abstract class NavigatorMenuController
implements Controller {
    protected static int NO_TOOLBAR_CMD_ID = -1;
    private final int m_navCmd;
    private final int m_toolbarCmd;

    protected NavigatorMenuController(int n, int n2) {
        assert (n > 0);
        this.m_navCmd = n;
        this.m_toolbarCmd = n2;
    }

    protected abstract NavigatorManager getNavMgr();

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.m_navCmd) {
            this.showNavigatorWindow();
            return true;
        }
        if (n == this.m_toolbarCmd) {
            NavigatorManager navigatorManager;
            navigatorManager.setToolbarVisible(!(navigatorManager = this.getNavMgr()).isToolbarVisible());
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.m_navCmd) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == this.m_toolbarCmd) {
            ideAction.setState(this.getNavMgr().isToolbarVisible());
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    private NavigatorWindow getNavigatorWindow() {
        return this.getNavMgr().getNavigatorWindow();
    }

    private void showNavigatorWindow() {
        DockStation dockStation = DockStation.getDockStation();
        NavigatorWindow navigatorWindow = this.getNavigatorWindow();
        dockStation.setDockableVisible((Dockable)navigatorWindow, true);
        dockStation.activateDockable((Dockable)navigatorWindow);
    }

    private void toggleToolbarVisibility(boolean bl) {
    }
}

