/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.javafx.query;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.util.StringConverter;
import oracle.dbtools.raptor.javafx.query.FxSingleRowQuery;

public class FxTimeSeriesChartQuery
extends FxSingleRowQuery<Map<String, XYChart.Series<Number, Number>>> {
    private NumberAxis timeAxis;
    private LongProperty observableCurrentLongDate = new ReadOnlyLongWrapper();
    private long period = 3600000L;
    private DateFormat dateFormat = DateFormat.getDateInstance(3);
    private DateFormat timeFormat = DateFormat.getTimeInstance(3);

    public FxTimeSeriesChartQuery(String string, String string2) {
        super(string, string2);
    }

    public void initTimeAxis(NumberAxis numberAxis) {
        assert (numberAxis != null);
        this.timeAxis = numberAxis;
        this.calculateTickUnits();
        numberAxis.setTickLabelFormatter((StringConverter)new LongDateLabelConverter(this.timeFormat));
        if (this.dateFormat != null) {
            numberAxis.labelProperty().bind((ObservableValue)new LongDateLabelBinding(this.observableCurrentLongDate, this.dateFormat));
        }
        numberAxis.setForceZeroInRange(false);
        numberAxis.setAutoRanging(false);
    }

    @Override
    protected boolean bindImpl(Map<String, Object> map, Map<String, XYChart.Series<Number, Number>> map2) {
        for (String string : map2.keySet()) {
            if (map.get(string) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updateObservableValuesImpl(Map<String, Object> map) {
        long l = System.currentTimeMillis();
        this.observableCurrentLongDate.set(l);
        long l2 = l - this.period;
        long l3 = 0L;
        for (Map map2 : this.getTargets()) {
            for (String string : map2.keySet()) {
                Object object = map.get(string);
                if (object == null) continue;
                Number number = null;
                number = object instanceof Number ? (Number)object : new BigDecimal(object.toString());
                XYChart.Series series = (XYChart.Series)map2.get(string);
                series.getData().add((Object)new XYChart.Data((Object)l, (Object)number));
                while (((Number)((XYChart.Data)series.getData().get(0)).getXValue()).longValue() < l2) {
                    series.getData().remove(0);
                }
                long l4 = ((Number)((XYChart.Data)series.getData().get(0)).getXValue()).longValue();
                if (0L == l3) {
                    l3 = l4;
                    continue;
                }
                l3 = Math.min(l3, l4);
            }
        }
        this.timeAxis.setLowerBound((double)l3);
        this.timeAxis.setUpperBound((double)l);
    }

    private void calculateTickUnits() {
        if (this.timeAxis != null) {
            long l = this.getUpdateInterval();
            if (l > 0L) {
                this.period += this.period % l;
            }
            long l2 = l;
            while (this.period / l2 > 12L) {
                l2 += l;
            }
            this.period -= this.period % l2;
            if (0L == this.period / l2 % 2L) {
                this.period += l2;
            }
            this.timeAxis.setTickUnit((double)l2);
            this.timeAxis.setLowerBound(0.0);
            this.timeAxis.setUpperBound((double)this.period);
        }
    }

    @Override
    protected boolean unbindImpl(Map<String, XYChart.Series<Number, Number>> map) {
        return true;
    }

    public void setPeriod(long l) {
        this.period = l;
        this.calculateTickUnits();
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setTimeFormat(DateFormat dateFormat) {
        this.timeFormat = dateFormat;
    }

    public static class LongDateLabelConverter
    extends StringConverter<Number> {
        private DateFormat format;

        public LongDateLabelConverter(DateFormat dateFormat) {
            this.format = dateFormat;
        }

        public Number fromString(String string) {
            return Long.valueOf(string);
        }

        public String toString(Number number) {
            String string = "";
            if (this.format != null) {
                long l = 0L;
                if (number != null) {
                    l = number.longValue();
                }
                Date date = new Date(l);
                string = this.format.format(date);
            }
            return string;
        }
    }

    public static class LongDateLabelBinding
    extends StringBinding {
        private LongProperty observableLongDate;
        private DateFormat format;

        public LongDateLabelBinding(LongProperty longProperty, DateFormat dateFormat) {
            assert (longProperty != null);
            assert (dateFormat != null);
            this.observableLongDate = longProperty;
            this.format = dateFormat;
            this.bind(new Observable[]{this.observableLongDate});
        }

        protected String computeValue() {
            String string = "";
            if (this.format != null) {
                long l = this.observableLongDate.get();
                Date date = new Date(l);
                string = this.format.format(date);
            }
            return string;
        }
    }
}

