/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.javafx.query;

import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import oracle.dbtools.raptor.javafx.query.FxSingleRowQuery;

public class FxObservableValueMapQuery
extends FxSingleRowQuery<Map<String, Property<?>>> {
    private Map<String, ObservableValue<?>> observableValueMap = new HashMap();

    public FxObservableValueMapQuery(String string, String string2) {
        super(string, string2);
    }

    @Override
    protected boolean bindImpl(Map<String, Object> map, Map<String, Property<?>> map2) {
        int n = 0;
        Map<String, ObservableValue<?>> map3 = this.getObservableValueMap(map, map2);
        for (String string : map2.keySet()) {
            Property<?> property = map2.get(string);
            ObservableValue<?> observableValue = map3.get(string);
            if (observableValue == null) continue;
            this.bind(property, observableValue);
            ++n;
        }
        if (n > 0) {
            this.updateObservableValuesImpl(map);
            return true;
        }
        return false;
    }

    @Override
    protected boolean unbindImpl(Map<String, Property<?>> map) {
        int n = 0;
        Map<String, ObservableValue<?>> map2 = this.getObservableValueMap();
        for (String string : map.keySet()) {
            Property<?> property = map.get(string);
            ObservableValue<?> observableValue = map2.get(string);
            if (observableValue == null) continue;
            property.unbind();
            ++n;
        }
        return false;
    }

    @Override
    protected void updateObservableValuesImpl(Map<String, Object> map) {
        this.updateObservableValueMap(map);
    }

    private Map<String, ObservableValue<?>> getObservableValueMap(Map<String, Object> map, Map<String, Property<?>> map2) {
        Map<String, ObservableValue<?>> map3 = this.getObservableValueMap();
        for (String string : map2.keySet()) {
            Property<?> property = map2.get(string);
            ObservableValue<?> observableValue = map3.get(string);
            if (null != observableValue) continue;
            observableValue = this.createObservableValueFor(property);
            map3.put(string, observableValue);
        }
        return map3;
    }

    private void updateObservableValueMap(Map<String, Object> map) {
        assert (Platform.isFxApplicationThread());
        assert (map != null);
        Map<String, ObservableValue<?>> map2 = this.getObservableValueMap();
        for (String string : map2.keySet()) {
            ObservableValue<?> observableValue = map2.get(string);
            Object object = map.get(string);
            this.setObservableValue(observableValue, object);
        }
    }

    private Map<String, ObservableValue<?>> getObservableValueMap() {
        return this.observableValueMap;
    }
}

