/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.refactor.ProcedureExtractor;
import oracle.dbtools.util.Service;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.TextTabber;
import oracle.javatools.editor.insight.ListInsightData;

public class DBListInsightData
implements ListInsightData {
    private Logger logger = Logger.getLogger(DBListInsightData.class.getName());
    protected ListModel instance = new ListModel(){

        public Object getElementAt(int n) {
            if (n >= DBListInsightData.this._matchingDataList.length || n < 0) {
                return null;
            }
            return DBListInsightData.this._matchingDataList[n];
        }

        @Override
        public int getSize() {
            return DBListInsightData.this._matchingDataList.length;
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }
    };
    protected SuggestedItem[] _matchingDataList;
    final CompletionInsight _insight;
    private boolean completedOnce = false;
    private static final EditDescriptor _editDescriptor = new EditDescriptor("Undo Completion");

    DBListInsightData(CompletionInsight completionInsight) {
        this._insight = completionInsight;
    }

    public Object[] getData() {
        return this.getMatchingData();
    }

    public Object[] getMatchingData() {
        int n = this._insight.getAliacedPrefix().length();
        if (n > 0) {
            int n2;
            TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
            for (SuggestedItem suggestedItem : this._matchingDataList) {
                if ("...".equals(suggestedItem.getName()) || "TEMPLATE".equals(suggestedItem.getType())) {
                    treeSet.add(suggestedItem);
                    continue;
                }
                int n3 = n;
                if ("".equals(suggestedItem.getOwner())) {
                    n3 = this._insight.identifierPrefix.length();
                }
                suggestedItem.setPrefixLength(n3);
                treeSet.add(suggestedItem);
            }
            if (this._insight.wasAutoInvoked && (n2 = DBConfig.getInstance().getInt("MAXTRIGGERCOMPLETIONLISTSIZE")) < treeSet.size()) {
                return new SuggestedItem[0];
            }
            this._matchingDataList = new SuggestedItem[treeSet.size()];
            int n4 = 0;
            for (SuggestedItem suggestedItem : treeSet) {
                this._matchingDataList[n4++] = suggestedItem;
            }
        }
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object object) {
        if (this.completedOnce) {
            return false;
        }
        this.completedOnce = true;
        SuggestedItem suggestedItem = (SuggestedItem)object;
        Object object2 = suggestedItem.format();
        String string = suggestedItem.getType();
        if (((String)object2).startsWith("...")) {
            if (string.equals("SNIPPET")) {
                this._insight.raiseSlimit = true;
            } else if (string.equals("HISTORY")) {
                this._insight.raiseHlimit = true;
            } else if (string.equals("TEMPLATE")) {
                this._insight.raiseTlimit = true;
            } else {
                this._insight.raiselimit = true;
            }
            final BasicEditorPane basicEditorPane = this._insight.getEditorPane();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    basicEditorPane.invokeAction("completion-insight");
                }
            };
            SwingUtilities.invokeLater(runnable);
            return false;
        }
        BasicDocument basicDocument = this._insight.getDocument();
        int n = this._insight.getCaretPosition();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        basicEditorPane.beginEdit(DBListInsightData.getEditDescriptor());
        try {
            int n2;
            int n3;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n4 : this._insight.getInsightView().getSelectedIndices()) {
                hashSet.add(n4);
            }
            Object object3 = new LinkedList();
            for (int n5 : this._insight.selectionOrder) {
                if (!hashSet.contains(n5)) continue;
                object3.add(n5);
            }
            this._insight.selectionOrder.clear();
            if (n < this._insight.startCaretPosition) {
                boolean bl = false;
                return bl;
            }
            int n6 = suggestedItem.getPrefixLength();
            if (object3.size() > 1) {
                int n4;
                object2 = "";
                String[] stringArray = new String[object3.size()];
                n4 = 0;
                String[] stringArray2 = object3.iterator();
                while (stringArray2.hasNext()) {
                    n3 = (Integer)stringArray2.next();
                    stringArray[n4++] = this._matchingDataList[n3].toString();
                }
                stringArray2 = this.generateAliases(stringArray);
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    String string2 = stringArray[n3];
                    object2 = string2.indexOf(61) >= 0 ? (String)object2 + (n3 == 0 ? "" : " AND ") + string2 : (String)object2 + (n3 == 0 ? "" : ", ") + string2 + " " + stringArray2[n3];
                }
            }
            object2 = ((String)object2).replace(SuggestedItem.getPlaceholderPrefix(), "[");
            object2 = ((String)object2).replace(SuggestedItem.placeholderSuffix, "]");
            object2 = ((String)object2).replace("&lt;", "<");
            object2 = ((String)object2).replace("&gt;", ">");
            object2 = ((String)object2).replace("<html>", "");
            object2 = ((String)object2).replace("</html>", "");
            object2 = ((String)object2).replace("<font color=green>", "");
            object2 = ((String)object2).replace("</font>", "");
            object2 = ((String)object2).replace("<b>", "");
            if (((String)(object2 = ((String)object2).replace("</b>", ""))).toUpperCase().startsWith("PUBLIC.")) {
                object2 = ((String)object2).substring("PUBLIC.".length());
            }
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            StringBuilder stringBuilder = new StringBuilder();
            if (!(((String)object2).indexOf(32) <= 0 || "SNIPPET".equals(string) || "HISTORY".equals(string) || "TEMPLATE".equals(string) || "ARGUMENT".equals(string))) {
                try {
                    object2 = CustomFormat.getInstance().format((String)object2);
                    int n7 = ((String)object2).indexOf("\n/***");
                    if (0 < n7) {
                        n3 = ((String)object2).indexOf("***/") + "***/".length();
                        object2 = ((String)object2).substring(0, n7) + ((String)object2).substring(n3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string3 = ProcedureExtractor.indent(n, basicEditorPane);
            object2 = ((String)object2).replace("\n", "\n" + string3);
            if ("ARGUMENT".equals(string) && !this.balancedParen(this._insight.parser.src)) {
                object2 = (String)object2 + "\n" + string3 + ");";
            }
            n3 = n - n6;
            if (n6 > 0 && basicDocument.getText(n3, n6).contains("\n")) {
                n3 = DBListInsightData.tokenStart(this._insight.parser.src, n3);
            }
            int n8 = n2 = 0 < ((String)object2).indexOf(46) ? DBListInsightData.dotNameOffset(this._insight.parser.src, n3, (String)object2) : DBListInsightData.dotNameOffset(this._insight.parser.src, n3, n);
            if (n2 != 0) {
                n3 += n2;
                n6 -= n2;
            } else {
                int n9 = DBListInsightData.ownerOffset(this._insight.parser.src, n3, (String)object2);
                if (0 < n9) {
                    n3 += n9;
                    n6 -= n9;
                }
            }
            basicDocument.remove(n3, n6);
            if (((String)object2).indexOf("]") > 0) {
                TextTabber textTabber = new TextTabber(basicEditorPane);
                int n10 = 0;
                int n11 = -1;
                int n12 = 0;
                while ((n11 = ((String)object2).indexOf("[", n10)) >= 0) {
                    stringBuilder.append(((String)object2).substring(n10, n11));
                    n10 = ((String)object2).indexOf("]", n11) + "]".length();
                    linkedList.add(Service.pair((int)(n3 + n11 - n12), (int)(n3 + n10 - "]".length() - "[".length() - n12)));
                    stringBuilder.append(((String)object2).substring(n11 + "[".length(), n10 - "]".length()));
                    n12 += "[".length() + "]".length();
                }
                stringBuilder.append(((String)object2).substring(n10));
                basicDocument.insertString(n3, stringBuilder.toString(), null);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    int n13 = (Integer)iterator.next();
                    textTabber.addRange(Service.X((int)n13), Service.Y((int)n13));
                }
                textTabber.setActive(true);
            } else {
                basicDocument.insertString(n3, (String)object2, null);
            }
        }
        catch (BadLocationException badLocationException) {
            this.logger.warning("Exception occurred in completion: " + badLocationException);
        }
        finally {
            basicEditorPane.endEdit();
        }
        return false;
    }

    private boolean balancedParen(List<LexerToken> list) {
        if (list == null) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        for (LexerToken lexerToken : list) {
            if ("(".equals(lexerToken.content)) {
                ++n;
            }
            if (!")".equals(lexerToken.content)) continue;
            ++n2;
        }
        return n <= n2;
    }

    private static int tokenStart(List<LexerToken> list, int n) {
        int n2 = n;
        if (list == null) {
            return n2;
        }
        for (LexerToken lexerToken : list) {
            if (lexerToken.begin > n) break;
            if (lexerToken.type == Token.WS) continue;
            n2 = lexerToken.begin;
        }
        return n2;
    }

    private static int dotNameOffset(List<LexerToken> list, int n, String string) {
        if (list == null) {
            return 0;
        }
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            return 0;
        }
        String string2 = string.substring(0, n2).toLowerCase();
        String string3 = null;
        String string4 = null;
        for (LexerToken lexerToken : list) {
            if (n <= lexerToken.begin) break;
            string3 = string4;
            string4 = lexerToken.content;
        }
        if (!".".equals(string4)) {
            return 0;
        }
        if (!string2.equals(string3.toLowerCase())) {
            return 0;
        }
        return -string2.length() - 1;
    }

    private static int dotNameOffset(List<LexerToken> list, int n, int n2) {
        if (list == null) {
            return 0;
        }
        String string = null;
        boolean bl = false;
        for (LexerToken lexerToken : list) {
            if (lexerToken.end <= n) continue;
            if (n2 < lexerToken.begin) {
                return 0;
            }
            if (".".equals(lexerToken.content)) {
                bl = true;
                break;
            }
            string = lexerToken.content;
        }
        if (bl) {
            return string.length() + 1;
        }
        return 0;
    }

    private static int ownerOffset(List<LexerToken> list, int n, String string) {
        if (list == null) {
            return 0;
        }
        String string2 = string;
        int n2 = string2.indexOf(46);
        if (0 < n2) {
            string2 = string2.substring(0, n2);
        }
        String string3 = null;
        String string4 = null;
        for (LexerToken lexerToken : list) {
            if (lexerToken.begin < n) continue;
            if (string4 != null) {
                if (string2.equals(lexerToken.content.toLowerCase())) break;
                return 0;
            }
            if (string3 == null) {
                string3 = lexerToken.content;
                continue;
            }
            string4 = lexerToken.content;
        }
        if (!".".equals(string4)) {
            return 0;
        }
        if (string2.equalsIgnoreCase(string3)) {
            return 0;
        }
        return string3.length() + 1;
    }

    /*
     * WARNING - void declaration
     */
    private String[] generateAliases(String[] stringArray) {
        int n;
        String string = this._insight.prior.content.toUpperCase();
        if (!DBConfig.getInstance().getBoolean("AUTOGENERATEALIASES").booleanValue() || !"SELECT".equals(string) && !"FROM".equals(string)) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = "";
            }
            return stringArray2;
        }
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray[i].indexOf(".") > 0 ? stringArray[i].substring(stringArray[i].lastIndexOf(".") + 1) : stringArray[i];
        }
        String string2 = stringArray3[0];
        for (String stringArray4 : stringArray3) {
            string2 = DBListInsightData.commonPrefix(string2, stringArray4);
        }
        int n2 = 1;
        int n3 = 1;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (String string3 : stringArray3) {
            void var12_24;
            String string4;
            String string5 = string4 = string3.length() >= string2.length() + n2 ? string3.substring(string2.length(), string2.length() + n2) : string3.substring(0, Integer.min(string3.length(), n2));
            if (string4.startsWith("_")) {
                n3 = 0;
            }
            try {
                n = Integer.parseInt(string4);
                n3 = 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n3 == 0) {
                String string6 = string2 + string4;
            }
            if (linkedList.contains(var12_24)) {
                linkedList = new LinkedList();
                ++n2;
                break;
            }
            linkedList.add(var12_24);
        }
        n3 = 1;
        if (n2 == 2) {
            for (String string3 : stringArray3) {
                void var12_30;
                String string7;
                String string8 = string7 = string3.length() >= string2.length() + n2 ? string3.substring(string2.length(), string2.length() + n2) : string3.substring(0, Integer.min(string3.length(), n2));
                if (string7.startsWith("_")) {
                    n3 = 0;
                }
                try {
                    n = Integer.parseInt(string7);
                    n3 = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n3 == 0) {
                    String string9 = string2 + string7;
                }
                if (linkedList.contains(var12_30)) {
                    linkedList = new LinkedList();
                    ++n2;
                    break;
                }
                linkedList.add(var12_30);
            }
        }
        n3 = 1;
        if (n2 == 3) {
            boolean bl = true;
            for (String string10 : stringArray3) {
                void var8_18;
                Object object;
                Object object2 = object = string10.length() >= string2.length() + n2 ? string10.substring(string2.length(), string2.length() + n2) : string10.substring(0, Integer.min(string10.length(), n2));
                if (((String)object).startsWith("_")) {
                    n3 = 0;
                }
                try {
                    int n4 = Integer.parseInt((String)object);
                    n3 = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n3 == 0) {
                    object = string2 + (String)object;
                }
                if (!linkedList.contains(object)) {
                    linkedList.add(object);
                    continue;
                }
                linkedList.add((String)object + (int)(++var8_18));
            }
        }
        return linkedList.toArray(new String[0]);
    }

    private static String commonPrefix(String string, String string2) {
        if (string2.startsWith(string)) {
            return string;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return "";
        }
        return DBListInsightData.commonPrefix(string.substring(0, string.length() - 1), string2);
    }

    static EditDescriptor getEditDescriptor() {
        return _editDescriptor;
    }

    public void partialComplete() {
    }

    public ListModel getListModel() {
        return this.instance;
    }

    protected void setData(SuggestedItem[] suggestedItemArray) {
        int n;
        if (this._insight.wasAutoInvoked && (n = DBConfig.getInstance().getInt("MAXTRIGGERCOMPLETIONLISTSIZE")) < suggestedItemArray.length) {
            this._matchingDataList = new SuggestedItem[0];
            return;
        }
        this._matchingDataList = suggestedItemArray;
    }
}

