/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.features;

import java.net.URL;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ide.extension.ElementName;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.connections.AbstractConnectionListener;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.ConnectionInitializer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.Preferences;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class DatabaseFeatureRegistryImpl
extends DatabaseFeatureRegistry {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-feature";
    private static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-feature", "sqldev-feature-hook");
    private static final String TEXT = "#text";
    private static final String FEATURE_DESCRIPTOR = "feature-descriptor";
    private static final String ELEMENT_FEATURE = "dynamicFeature";
    private static final String ATTRIBUTE_ID = "id";
    private static DatabaseFeatureRegistryImpl INSTANCE = new DatabaseFeatureRegistryImpl();
    private Listener m_listener;
    private Map<String, DynamicFeature> dynamicFeatures;
    private Map<Connection, String> connNames = new WeakHashMap<Connection, String>();

    public static DatabaseFeatureRegistryImpl getInstance() {
        return INSTANCE;
    }

    private DatabaseFeatureRegistryImpl() {
    }

    protected void initialize() {
        Connections connections = Connections.getInstance();
        connections.addConnectionListener(new AbstractConnectionListener(){

            @Override
            public void connectionRenamed(ConnectionEvent connectionEvent) {
                this.handleRename(connectionEvent);
            }

            private void handleRename(ConnectionEvent connectionEvent) {
                String string;
                String string2 = connectionEvent.getOldName();
                if (ModelUtil.areDifferent((Object)string2, (Object)(string = connectionEvent.getConnectionName()))) {
                    Settings settings = Settings.getSettings();
                    settings.updateConnectionName(string2, string);
                }
            }

            @Override
            public void connectionRemoved(ConnectionEvent connectionEvent) {
                String string = connectionEvent.getConnectionName();
                Settings settings = Settings.getSettings();
                settings.removeConnection(string);
            }

            @Override
            public void connectionModified(ConnectionEvent connectionEvent) {
                this.handleRename(connectionEvent);
            }
        });
        connections.addInitializer(new ConnectionInitializer(){

            @Override
            public void initializeConnection(ConnectionDetails connectionDetails) {
                Connection connection = connectionDetails.getConnection();
                if (Connections.getInstance().isOracle(connection)) {
                    DatabaseFeatureRegistryImpl.this.initializeFeatures(DefaultConnectionIdentifier.createIdentifier((Connection)connection));
                    String string = connectionDetails.getQualifiedConnectionName();
                    if (string != null) {
                        DatabaseFeatureRegistryImpl.this.connNames.put(connection, string);
                    }
                }
            }
        });
        connections.addConnectionDisconnectListener(new ConnectionDisconnectListener(){

            @Override
            public void connectionDisconnected(ConnectionDetails connectionDetails) {
                Connection connection = connectionDetails.getConnection();
                if (Connections.getInstance().isOracle(connection)) {
                    DatabaseFeatureRegistryImpl.this.cleanupFeatures(DefaultConnectionIdentifier.createIdentifier((Connection)connection));
                    DatabaseFeatureRegistryImpl.this.connNames.remove(connection);
                }
            }

            @Override
            public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
            }
        });
    }

    protected boolean isFeatureEnabledImpl(ConnectionIdentifier connectionIdentifier, String string) {
        boolean bl = false;
        if (this.dynamicFeatures.containsKey(string)) {
            String string2 = this.connNames.get(connectionIdentifier.getConnection());
            if (string2 != null) {
                return this.isDynamicFeatureEnabled(string2, string);
            }
        } else {
            bl = super.isFeatureEnabledImpl(connectionIdentifier, string);
        }
        return bl;
    }

    protected void loadFeaturesImpl() {
        this.dynamicFeatures = new HashMap<String, DynamicFeature>();
        HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
        this.m_listener = new Listener();
        hashStructureHook.addHashStructureHookListener((HashStructureHookListener)this.m_listener);
    }

    Collection<DynamicFeature> getDynamicFeatures() {
        this.loadFeatures();
        return Collections.unmodifiableCollection(this.dynamicFeatures.values());
    }

    boolean isDynamicFeatureEnabled(String string, String string2) {
        Settings settings = Settings.getSettings();
        return settings.getFeatureState(string, string2);
    }

    void setDynamicFeatureEnabled(String string, String string2, boolean bl) {
        Settings settings = Settings.getSettings();
        settings.setFeatureState(string, string2, bl);
    }

    private final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processHooks(HashStructure hashStructure) {
            Object object;
            Object object2;
            HashStructure hashStructure2;
            List list = hashStructure.getAsList(DatabaseFeatureRegistryImpl.FEATURE_DESCRIPTOR);
            if (list != null) {
                for (Object e : list) {
                    hashStructure2 = (HashStructure)e;
                    object2 = LazyResourceAdapter.getInstance((HashStructure)hashStructure2).getMetaResource(DatabaseFeatureRegistryImpl.TEXT);
                    object = object2.toURL();
                    if (object == null) continue;
                    ClassLoader classLoader = object2.getClassLoader();
                    DatabaseFeatureRegistryImpl.this.processURL((URL)object, classLoader);
                }
            }
            if ((list = hashStructure.getAsList(DatabaseFeatureRegistryImpl.ELEMENT_FEATURE)) != null) {
                for (Object e : list) {
                    hashStructure2 = (HashStructure)e;
                    object2 = hashStructure2.getString(DatabaseFeatureRegistryImpl.ATTRIBUTE_ID);
                    if (object2 == null) {
                        Logger.warn(DatabaseFeatureRegistryImpl.class, (String)"Missing id for dynamic feature");
                        continue;
                    }
                    object = hashStructure2.getString(DatabaseFeatureRegistryImpl.TEXT);
                    DatabaseFeatureRegistryImpl.this.dynamicFeatures.put((String)object2, new DynamicFeature((String)object2, (String)object));
                }
            }
        }
    }

    private static class Settings
    extends HashStructureAdapter {
        private static final String SETTINGS_KEY = "DatabaseFeatureRegistery.DynamicFeatureSettings";
        private static final String NAMES_KEY = "ConnectionNames";

        static Settings getSettings() {
            return new Settings(Settings.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)SETTINGS_KEY));
        }

        Settings(HashStructure hashStructure) {
            super(hashStructure);
        }

        boolean getFeatureState(String string, String string2) {
            HashStructure hashStructure;
            boolean bl = false;
            HashStructure hashStructure2 = this._hash.getHashStructure(NAMES_KEY);
            if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
                bl = hashStructure.getBoolean(string2);
            }
            return bl;
        }

        void setFeatureState(String string, String string2, boolean bl) {
            HashStructure hashStructure = Settings.findOrCreate(NAMES_KEY, this._hash);
            HashStructure hashStructure2 = Settings.findOrCreate(string, hashStructure);
            hashStructure2.putBoolean(string2, bl);
        }

        void updateConnectionName(String string, String string2) {
            HashStructure hashStructure;
            HashStructure hashStructure2 = this._hash.getHashStructure(NAMES_KEY);
            if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
                hashStructure2.remove(string);
                hashStructure2.putHashStructure(string2, hashStructure);
            }
        }

        void removeConnection(String string) {
            HashStructure hashStructure = this._hash.getHashStructure(NAMES_KEY);
            if (hashStructure != null) {
                hashStructure.remove(string);
            }
        }

        private static HashStructure findOrCreate(String string, HashStructure hashStructure) {
            HashStructure hashStructure2 = hashStructure.getHashStructure(string);
            if (hashStructure2 == null) {
                hashStructure2 = HashStructure.newInstance();
                hashStructure.putHashStructure(string, hashStructure2);
            }
            return hashStructure2;
        }
    }

    static class DynamicFeature {
        final String id;
        final String label;

        DynamicFeature(String string, String string2) {
            this.id = string;
            this.label = string2;
        }

        String getID() {
            return this.id;
        }

        String getLabel() {
            return this.label;
        }
    }
}

