/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.ui.panels.SelectDataPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public abstract class ExtractWizDataSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private SelectDataPanel dp = null;
    private boolean isTablespaceEnabled = false;
    private boolean isSchemasEnabled = false;
    protected TraversableContext _dataContext;
    private ExtractListModel _listModel = null;

    public ExtractWizDataSelector() {
        this.setLayout(new GridBagLayout());
        this.dp = new SelectDataPanel();
        this.add(this.dp.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onExit(TraversableContext traversableContext) {
        this.dp.onExit();
    }

    public abstract Object getExitTransition();

    public void onEntry(TraversableContext traversableContext) {
        this._dataContext = traversableContext;
        this._listModel = this.getListModel();
        if (this.isAddMultipleSchemas()) {
            this.dp.setAddMultipleSchemas(true);
            this.dp.setMultipleSchemaNames(this.getMultipleSchemas());
        }
        if (this.isAddTableSpace()) {
            this.dp.setAddTableSpace(true);
            this.dp.setTablespaceNames(this.getTablespaces());
            this.dp.setMultipleSchemaNames(this.getTablespaceSchemas());
        }
        this.dp.setDataObjects((ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL"));
        this.dp.updatePanel(true);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        traversableContext.getWizardCallbacks().wizardSetInitialFocus((Component)this.dp);
    }

    protected ExtractListModel getListModel() {
        if ((ExtractListModel)this._dataContext.get("EXTRACT_LIST_MODEL") == null) {
            this._dataContext.put("EXTRACT_LIST_MODEL", (Object)new ExtractListModel());
        }
        return (ExtractListModel)this._dataContext.get("EXTRACT_LIST_MODEL");
    }

    protected void setAddTableSpace(boolean bl) {
        this.isTablespaceEnabled = bl;
    }

    protected void setAddMultipleSchemas(boolean bl) {
        this.isSchemasEnabled = bl;
    }

    public boolean isAddMultipleSchemas() {
        return this.isSchemasEnabled;
    }

    public boolean isAddTableSpace() {
        return this.isTablespaceEnabled;
    }

    public String[] getMultipleSchemas() {
        List list = (List)this._dataContext.get("EXTRACT_SCHEMA_LIST");
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    private String[] getTablespaceSchemas() {
        return (String[])this._dataContext.get("TABLESPACE_SCHEMAS");
    }

    private String[] getTablespaces() {
        return (String[])this._dataContext.get("SOURCE_TABLESPACES");
    }
}

